#include "mbed.h"
#include "ARAP180.h"
#include "platform/mbed_thread.h"
ARAP180 arm;
    

 
int main() {
arm.initArmMotors();
 
Vector6f q = Vector6f::Zero();
Vector6f q_out = Vector6f::Zero();
Vector6f q_out_sat = Vector6f::Zero();

Matrix4f T = Matrix4f::Zero();
Matrix6f J = Matrix6f::Zero();    
Matrix4f Td = Matrix4f::Identity();


Matrix4f T_e_b_0 = Matrix4f::Zero();
/*T_e_b_0(0,2) = 1.0;
T_e_b_0(1,0) = -1.0;
T_e_b_0(2,1) = -1.0;
T_e_b_0(0,3) = 0.142;
T_e_b_0(2,3) = -0.213;
T_e_b_0(3,3) = 1.0;*/



Matrix4f T_e_b = Matrix4f::Identity();
Matrix4f RotoTraslation = Matrix4f::Identity();

Matrix4f T_r_e = Matrix4f::Identity();

T_r_e(1,3) = -0.218;

double t = 0.0;

Vector6f q0 = Vector6f::Zero();
Vector6f q_offsetted = Vector6f::Zero();
Vector6f q_act = Vector6f::Zero();
//q0 = arm.getJointPos();
q0(0) = 0.0;
q0(1) = M_PI/4;
q0(2) = M_PI/3;
q0(3) = -M_PI/3 + M_PI/4;
q0(4) = M_PI/2;
q0(5) = 0.0;
T_e_b_0 = arm.forwardKinematics(q0);


q_out = q0;

float traslation_x; 
float traslation_y; 
float traslation_z;

arm.setJointPos(q0);

wait_us(5000000);

arm.setMaxVel(100);

arm.setMaxAcc(100);

while (true){
   

    traslation_x = 0.0;//0.3*sin(0.2*2*M_PI*t);//+0.15*sin(0.2*2*M_PI*t);
    traslation_y = 0.0;//-0.4*sin(0.2*2*M_PI*t);
    traslation_z = 0.25*sin(0.2*2*M_PI*t);//-0.15*sin(0.2*2*M_PI*t);//0.3+0.1*sin(0.2*2*M_PI*t);

    RotoTraslation.block(0,0,3,3) = utilities::rotx(0.0);//utilities::rotx((M_PI/3)*sin(0.2*2*M_PI*t));
   
    RotoTraslation(0,3) = traslation_x;
    RotoTraslation(1,3) = traslation_y;
    RotoTraslation(2,3) = traslation_z;
    
    T_e_b=T_e_b_0*T_r_e*RotoTraslation*T_r_e.inverse();
    
    //T_e_b=T_e_b_0*RotoTraslation;
    
    T_e_b.block(0,0,3,3) = utilities::matrixOrthonormalization(T_e_b.block(0,0,3,3));
    
    //T_e_b(0,3) = traslation_x;
    //T_e_b(1,3) = traslation_y;
    //T_e_b(2,3) = traslation_z;
    
    /*printf("T_e_b=\n");
    for(int i = 0; i<4; i++){
    for(int j = 0; j<4; j++){
        printf("%4.3f", T_e_b(i,j));
    }
    printf("\r\n\n"); 
    } */

    q_out = arm.backwardKinematics(T_e_b, q_out, 0.005, 1, 0.001, 0.001 ,150, 50);

    q_out_sat =  arm.jointSaturation(q_out);
    //q_out = Vector6f::Zero();

    
    /*printf("q=");
    for(int i = 0; i<6; i++){
        printf(" %4.1f",q_out[i]);
    }
    printf("\r\n"); */  
    
     /*   printf("q_sat=");
    for(int i = 0; i<6; i++){
        printf(" %4.1f",q_out_sat[i]);
    }
    printf("\r\n\n"); */ 
    
    //q_act = arm.getJointPos();
    
    
    
   /* printf("q_act = ");
    for(int i = 0; i<6; i++){
        printf(" %4.2f ",q_act[i]);
    }
    printf("\r\n");*/
    
    arm.setJointPos(q_out);
    
    //arm.gravityVector(q);
    //arm.inertiaMatrix(q);
    //arm.stiffnessVector(q);
    //arm.frictionVector(q);
    
    

    
    t = t+0.001;
    wait_us(1000);

}

     
}

