/*This file is part of dvrk-dynamics package.
 * Copyright (C) 2017, Giuseppe Andrea Fontanelli
 
 * Email id : giuseppeandrea.fontanelli@unina.it
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the names of Stanford University or Willow Garage, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived from
 *     this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
* This code will subscriber integer values from demo_topic_publisher
*/

#ifndef _ARAP180_H
#define _ARAP180_H
#include "mbed.h"
#include "Core.h"
#include <Eigen/Dense.h>
#include "utilities.hpp"
#include "UARTSerial_half.h"
#include "MX.h"

using namespace Eigen;
using namespace std;

typedef Matrix<double, 6, 1> Vector6d;
typedef Matrix<double, 7, 1> Vector7d;
typedef Matrix<double, 6, 6> Matrix6d;
typedef Matrix<float, 6, 1> Vector6f;
typedef Matrix<float, 7, 1> Vector7f;
typedef Matrix<float, 6, 6> Matrix6f;

class ARAP180
{
	private:

		string robName;
		string paramFile;
		
		 
	    bool read_parameters_from_file(string paramFile);
		Vector6f q_sat_max;	
		Vector6f q_sat_min;	
		
		
		UARTSerial_half *dxl_port; 
		
		int ID[5];
		int operatingMode[5];
		bool enableVal[5];
		MX *mx_MotorChain;  
		
		Vector6f offsets;
		
		Vector6f motorSign;




	public:

		/* brief Constructor. */
		ARAP180();
		VectorXf get_parameters();
		
		Matrix6f jacobianMatrix(Vector6f q);	//Jacobian matrix
		Matrix4f forwardKinematics(Vector6f q);	//Dyrect kinematics
		Vector6f backwardKinematics(Matrix4f T_d, Vector6f q, float _Tsam, int _n_max_iter, float _max_pError, float _max_oError ,float _Kp, float _Ko);	//Dyrect kinematics
		
		Vector6f jointSaturation(Vector6f q);

		Matrix6f inertiaMatrix(Vector6f q);	//Inertia matrix
		Matrix6f coriolisCentrifugalMatrix(Vector6f q, Vector6f dq); //Coriolis and centrifugal matrix
	
		Vector6f gravityVector(Vector6f q);	//Gravity vector
		Vector6f frictionVector(Vector6f dq);	//Friction vector
		Vector6f stiffnessVector(Vector6f q);	//Friction vector
		
		void initArmMotors();
        Vector6f getJointPos();
        void setJointPos(Vector6f q);
        
        		
		void setMaxVel(float maxVel);
		void setMaxAcc(float maxAcc);
        
        



};

#endif // _ARMHyfliers_H

