#ifndef CONTROL_DEFINE_VARIABLES_H
#define CONTROL_DEFINE_VARIABLES_H

//NUCLEO-F767ZI
#define FRONT_ION_TX PB_9
#define FRONT_ION_RX PB_8
#define REAR_ION_TX PG_14
#define REAR_ION_RX PG_9
#define MPU_SDA PF_15
#define MPU_SCL PF_14
#define SERVO_1 PE_11 //actx1
#define SERVO_2 PE_9  //actx2
#define LED_ORANGE PG_2
#define LED_RED PG_3
#define LOOP_HB PE_6

//NUCLEO-H743ZI2
/*
#define FRONT_ION_TX PB_9
#define FRONT_ION_RX PB_8
#define REAR_ION_TX PB_6
#define REAR_ION_RX PB_7
#define MPU_SDA PB_11
#define MPU_SCL PB_10
*/
/* motor defines*/
#define ionMcBoudRate  460800
#define frontBoardAddress  128
#define frontMotorGearBoxRatio  103
#define frontEncoderPulse  512
#define frontKt  0.00667
#define frontTransmissionRatio  1.0
#define retroTransmissionRatio  1.0
#define retroBoardAddress  129
#define retroMotorGearBoxRatio  103
#define retroEncoderPulse  512
#define retroKt  0.00667

/* rover geometric parameters */
#define r_wheels_ 0.0300               //wheels radius
#define longitudinalSemiDist_ 0.1980   //distance from center to front and rear axle
#define lateralSemiDist_  0.0767       //distance from center to left and right contact point (arc on pipe)

/* IMU defines*/
#define  FS_a 8192    //per avere letture in g, sarebbe 32768/4         perchè 4g è il fondo scala
#define  FS_g 131.072    //per avere letture in gradi/s, sarebbe 32768/250 perchè 250 è il fondo scala

/* control parameters*/
#define  dtBoard_ 0.002
#define  wheelsAcceleration_ 20000 
#define  Kp_stabilization_ 0.28 //0.3
#define  Kd_stabilization_ 0.08  //TODO LOWER

/* RC PWMs defines */
// avanzamento
#define minPwmVel_  1020.0  //[us]
#define maxPwmVel_  1980.0  //[us]
#define zeroPwmVel_ 1500.0  //[us]
#define deadzoneVel_  10.0  //[us]
#define maxVel_       0.05  //[m/s]
// switch modalità
#define downLo_   900.0  //[us]
#define downHi_   1100.0 //[us]
#define centerLo_ 1400.0 //[us]
#define centerHi_ 1600.0 //[us]
#define upLo_     1900.0 //[us]
#define upHi_     2100.0 //[us]
#define constTravelVel_ 0.005 //[m/s] .5 cm/s


#endif