//Communication messages for ethernet protocol
 
enum RobotCmd {
    IDLE_STATE,
    DISABLE_MOTORS,
    ENABLE_ROVER,
    ENABLE_ARM,
    ENABLE_TOOL,
    ARM_JOINT_CONTROL,
    ARM_KINEMATIC_CONTROL_FIRST_ORDER,
    ARM_KINEMATIC_CONTROL_SECOND_ORDER,
    CALIBRATE_ROVER_IMU,
    CALIBRATE_ROVER_LASERS,
    CALIBRATE_ARM_LASERS,
    GET_CURRENT_ROBOT_STATE,
    RESTART_BOARD,
    STOP_ALL
};


enum Status {
    ETH_CONNECTED,
    ETH_SRV_ACCEPTED,
    ETH_LOST_CONNECTION,
    ETH_WRONG_RECV_SIZE,
    ETH_CHECKSUM_ERROR,
    ETH_NEW_CNF,
    ETH_NEW_CMD,
    ETH_NEW_CMD_CURRENT_VAL_REQUEST,
    ETH_ERROR_SENDING_DATA,
    ETH_IDLE,
    ROBOT_SAFETY_MODE
};


enum ControlMode {
    IDLE_MODE,
    GET_ROBOT_STATE_MODE,
    JOINT_CONTROL_MODE,
    KINEMATIC_CONTROL_FIRST_ORDER_MODE,
    KINEMATIC_CONTROL_SECOND_ORDER_MODE,
    ADMITTANCE_CONTROL_MODE,
    HYBRID_CONTROL_MODE,
    HYBRID_ADMITTANCE_CONTROL_MODE,
    SAFETY_MODE
};

enum PacketId {
    ID_config,
    ID_receive_command_send_prec_val,
    ID_receive_command_send_current_val
};


struct DebugVector 
{
    float d1;
    float d2;
    float d3;
    float d4;
    float d5;
    float d6;
    float d7;
    float d8;
    float d9;
    float d10;
    float d11;
    float d12;
    float d13;
    float d14;
    float d15;
    float d16;
    float d17;
    float d18;
    float d19;
    float d20;
    float d21;
    float d22;
    float d23;
    float d24;

}; 

struct DataToTheBoard
{
    float roverForwardVel;
    float roverZVel; //speed around z axis (used to correct the rover orientation on the pipe)
    float roverFrontJointAngle;
    float roverRetroJointAngle;
    //Arm position in base frame
    float armX;
    float armY;
    float armZ;
    //Arm oriantation in base frame
    float armQ0;
    float armQ1;
    float armQ2;
    float armQ3;
    
    float drone_roll;
    float drone_pitch;
    
    float jointPos1;
    float jointPos2;
    float jointPos3;
    float jointPos4;
    float jointPos5;
    float toolOrientAroundPipeAxis;
    float roverLongitudinalPosition;
    bool toolEmatClose;

};


struct ConfigDataToTheBoard
{
    float wdTime;

    bool debug;
    
    float dtBoard;
    float r_frontWheel;
    float r_retroWheel;
    float pipeCurve_I;
    float pipeCurve_E;
    float pipeCurve_M;
    float retroFrontCentralDistance;
    float wheelsCntactPointDistanceFromPipeCenter;
    float pipeRadious;
    float Kp_stabilization;
    float Kd_stabilization;
    
        
    float Kp_zero_torque;
    float Ki_zero_torque;

    float wheelsAcceleration;
    
    float jacobianInversionWeight1;
    float jacobianInversionWeight2;
    float jacobianInversionWeight3;
    float jacobianInversionWeight4;
    float jacobianInversionWeight5;
    float jacobianInversionWeight6;
    float jacobianInversionWeight7;
    float jacobianInversionWeight8;
    
    
        // arm DH
    float a3;
    float a4;
    float a5;
    float a5i;
    float a6;
    float d7;
    // drone distances
    float x_0_r2;
    float y_0_r2;
    float z_0_r2;
    
    float massr; 
    float mpxr ;  
    float mpyr ; 
    float mpzr ; 
    float mass1; 
    float mpx1 ;  
    float mpy1 ; 
    float mpz1 ; 
    float mass2; 
    float mpx2 ;
    float mpy2 ;
    float mpz2 ;
    float mass3; 
    float mpx3 ;
    float mpy3 ;
    float mpz3 ;
    float mass4; 
    float mpx4 ;
    float mpy4 ;
    float mpz4 ;
    float mass5; 
    float mpx5 ;
    float mpy5 ;
    float mpz5 ;
    float mass6; 
    float mpx6 ;
    float mpy6 ;
    float mpz6 ;
    
    float mass_battery;
    float mpx_battery;
    float mpz_battery;
       
    float  kp_first_order;
    float  ko_first_order;
    float  kp_second_order;
    float  ko_second_order;
    float  dp_second_order;
    float  do_second_order;
    
    float  jointsMaxVel;
    float  jointsMaxAcc;
    float  jointsFilterOmega;
    float  jointsFilterZita;
    float  velAccSafetyFactor;
        
    float maxCartPos_x;
    float maxCartPos_y;
    float maxCartPos_z;

    float minCartPos_x;
    float minCartPos_y;
    float minCartPos_z;

    

};

struct DataFromTheBoard
{
    float roverForwardVel;
    float roverStabVel;
    float roverZVel; //speed around z axis (used to correct the rover orientation on the pipe)
    float roverPitchAngle;
    float roverOdom;
    float roverLaserFrontDx;
    float roverLaserFrontSx;
    float roverLaserRetroDx;
    float roverLaserRetroSx;
    
   //Arm position in base frame
    float misTebX;
    float misTebY;
    float misTebZ;
    //Arm oriantation in base frame
    float misTebQ0;
    float misTebQ1;
    float misTebQ2;
    float misTebQ3;
    
    float cmdJointPos1;
    float cmdJointPos2;
    float cmdJointPos3;
    float cmdJointPos4;
    float cmdJointPos5;
    float cmdJointPos6;
    
    float estRoverJointPos1;
    float estRoverJointPos2;
    
    float misArmJointPos1;
    float misArmJointPos2;
    float misArmJointPos3;
    float misArmJointPos4;
    float misArmJointPos5;
    float misArmJointPos6;
    
    float droneFx;
    float droneFy;
    float droneFz;
    float droneTx;
    float droneTy;
    float droneTz;
    
    float toolOrientAroundPipeAxis;
    
    float toolLaserFrontDx;
    float toolLaserFrontSx;
    float toolLaserRetroDx;
    float toolLaserRetroSx;
  
}; 

struct ComandMsg 
{
    int pId;
    RobotCmd Cmd;
    DataToTheBoard Data;
    uint8_t Checksum;
};

struct ConfigMsg 
{   
    int pId;
    ConfigDataToTheBoard Data;
    uint8_t Checksum;
};


struct ResponseMsg 
{
    int StatusData;
    int ControlModeData;
    DataFromTheBoard Data;
    DebugVector Dbv;

}; 


