
#include "mbed.h"
#include "IM920.h"


//コンストラクタ------------------------------------------------------------------
Serial pc(USBTX, USBRX, 115200);
Serial im920_serial(D1, D0, 115200);

IM920 im920(im920_serial, pc, 115200);
DigitalIn im920_busy(D3);
//------------------------------------------------------------------------------

//変数---------------------------------------------------------------------------
char input_pc;
int set_flag = 0;
char temp[100] = "";
char pres[100] = "";
int temp_element = 0;
int pres_element = 0;
//------------------------------------------------------------------------------

//無線ヘッダー--------------------------------------------------------------------
const char header_uplink = 1;
const char header_downlink = 2;
//------------------------------------------------------------------------------

//関数---------------------------------------------------------------------------
void readPC();
void upLink();
void setValue();
void downLink();
//------------------------------------------------------------------------------



// メイン関数---------------------------------------------------------------------
int main()
{
    pc.printf("\r\n");
    pc.printf("Pump remote control system!!!\r\n");
    pc.printf("Start : 1\r\n");
    pc.printf("Stop : 0\r\n");

    im920.attach(&downLink, header_downlink);
    pc.attach(readPC, Serial::RxIrq);

    while(1) {
    }
}
//------------------------------------------------------------------------------


void readPC()
{
    input_pc = pc.getc();
    //pc.printf("%d\r\n", input_pc);
    if(set_flag == 0) {
        upLink();
    }

    else if(set_flag == 1 || set_flag == 2) {
        setValue();
    }
}

void upLink()
{
    if(input_pc == '1') {
        im920.header(header_uplink);
        im920.write(input_pc);
        pc.printf("INPUT : 1\r\n");
        pc.printf("Please set temperature::");
        set_flag = 1;
        input_pc = '\0';
    }

    else if(input_pc == '0') {
        im920.header(header_uplink);
        im920.write(input_pc);
        pc.printf("INPUT : 0");
    }

    else if(input_pc == '\n') {
        if(im920_busy == 0) {
            im920.send();
            pc.printf("Send\r\n");
            input_pc = '\0';
        }
    }
}

void setValue()
{
    if(set_flag == 1) {
        if(input_pc != '\n') {
            temp[temp_element] = input_pc;
            temp_element = temp_element + 1;
            pc.printf("%c", input_pc);
        }

        else {
            pc.printf("\r\n");
            //pc.printf("temp::%f\r\n", atof(temp));
            im920.write((float)atof(temp));
            temp_element = 0;
            memset(temp, '\0', sizeof(temp));
            pc.printf("Please set Pressure::");
            set_flag = 2;
            input_pc = '\0';
        }
    }

    else if(set_flag == 2) {
        if(input_pc != '\n') {
            pres[pres_element] = input_pc;
            pres_element = pres_element + 1;
            pc.printf("%c", input_pc);
        }

        else {
            pc.printf("\r\n");
            //pc.printf("pres::%f\r\n", atof(pres));
            im920.write((float)atof(pres));
            temp_element = 0;
            memset(pres, '\0', sizeof(pres));
            pc.printf("If you want to determine the temperature and pressure value, pleace input CTRL+ENTER\r\n");
            set_flag = 0;
        }
    }
}



void downLink()
{
    if(im920.data[1] == 0) {
        pc.printf("Pump state   :: OFF\r\n");
    }

    else if(im920.data[1] == 1) {
        pc.printf("Pump state   :: ON\r\n");
    }

    if(im920.data[2] == 0) {
        pc.printf("Kettle state :: OFF\r\n");
    }

    else if(im920.data[2] == 1) {
        pc.printf("Kettle state :: ON\r\n");
    }
    pc.printf("temperature  :: %f[oC]\r\n", (float)im920.toFloat(3));
    pc.printf("pressure     :: %f[MPa]\r\n", (float)im920.toFloat(7));
    pc.printf("\r\n");
}

