#include "pqLPS22HB_lib.h"
#include "mbed.h"
#include "math.h"

/**********
コンストラクタ
・AD0がHIGHかLOWかを選択
・使用するI2Cを選択
**********/
pqLPS22HB_lib :: pqLPS22HB_lib(AD0 ad0, I2C &userI2C){
    slave = ad0;
    i2c = &userI2C;
}

/**********
センサー起動（void）
・データ更新レートを選択（1, 10, 25, 50, 75）
**********/
void pqLPS22HB_lib :: begin(int drate){
    cmd_ctrl_reg1[0] = CTRL_REG1;
    switch(drate){
        case 1:
        cmd_ctrl_reg1[1] = 0x10;
        break;
        
        case 10:
        cmd_ctrl_reg1[1] = 0x20;
        break;
        
        case 25:
        cmd_ctrl_reg1[1] = 0x30;
        break;
        
        case 50:
        cmd_ctrl_reg1[1] = 0x40;
        break;
        
        case 75:
        cmd_ctrl_reg1[1] = 0x50;
        break;
        
        default:
        cmd_ctrl_reg1[1] = 0x00;
    }

    i2c -> frequency(400000);
    i2c -> write(slave, cmd_ctrl_reg1, 2, true);
    //wait(0.5f);
}

/**********
FIFO設定（void）（未実装）
・モードを選択（したい）
・FIFO ウォーターマークレベルを選択（したい）
**********/
void pqLPS22HB_lib :: setFIFO(){ //??
    cmd_ctrl_reg2[0] = CTRL_REG2;
    cmd_ctrl_reg2[1] = 0x40;
    cmd_fifo_ctrl[0] = FIFO_CTRL;
    cmd_fifo_ctrl[1] = 0x5F;
    i2c -> write(slave, cmd_ctrl_reg2, 2, true);
    i2c -> write(slave, cmd_fifo_ctrl, 2, true);
}

/**********
Who Am I（int）
接続できているかを判定
接続OK：0
接続NG：-1
**********/
int pqLPS22HB_lib :: whoAmI(){
    cmd_who_am_i[0] = WHO_AM_I;
    i2c -> write(slave, cmd_who_am_i, 1, true);
    i2c -> read(slave | 1, &cmd_who_am_i[0], 1, true);
    
    if(cmd_who_am_i[0] == 0xB1){
        return 0;
    }
    else{
        return -1;
    }
}

/**********
気圧を取得（float）
**********/
float pqLPS22HB_lib :: getPres(){
    cmd_p[0] = P_XL;
    cmd_p[1] = P_L;
    cmd_p[2] = P_H;
    
    for(int c1 = 0; c1 < 3; c1 ++){
        i2c -> write(slave, &cmd_p[c1], 1, true);
        i2c -> read(slave | 1, &cmd_p[c1], 1, true);
        data_p[c1] = (int)cmd_p[c1];
    }
    
    return (float)(data_p[0] | data_p[1] << 8 | data_p[2] << 16) / 4096.0f;
}

/**********
温度を取得（float）
**********/
float pqLPS22HB_lib :: getTemp(){
    cmd_t[0] = T_L;
    cmd_t[1] = T_H;
    
    for(int c1 = 0; c1 < 2; c1 ++){
        i2c -> write(slave, &cmd_t[c1], 1, true);
        i2c -> read(slave | 1, &cmd_t[c1], 1, true);
        data_t[c1] = (int)cmd_t[c1];
    }
    
    if(data_t[1] >= 128){
        return 20.0 - (float)(65536 - (data_t[0] | data_t[1] << 8)) / 480.0f;
    }
    else{
        return 20.0 + (float)(data_t[0] | data_t[1] << 8) / 480.0f;
    }
}

/**********
高度を計算（float）
・引数に0m地点での気圧・温度を入れる
・計算式のソース：http://www.geocities.jp/u4ren6/Main/Excel_Data0017.html
**********/
float pqLPS22HB_lib :: getAlt(float P_0, float T_0){
    pres_0 = P_0;
    temp_0 = T_0;
    pres_now = getPres();
    
    return -(273.0 + temp_0) / 0.0342 * log(pres_now / pres_0);
}

/**********
高度を取得（float）
※温度の高度による変化を考慮
※こちらを推奨
・引数に0m地点での気圧・温度を入れる
・計算式のソース：http://zakii.la.coocan.jp/physics/31_pressure.htm
**********/
float pqLPS22HB_lib :: getAlt2(float P_0, float T_0){
    pres = getPres();
    return (273.0 + T_0) / 0.0065 * (1.0 - (float)pow((double)(pres / P_0), 0.190));
}