#ifndef PQ_LPS22HB_LIB_H
#define PQ_LPS22HB_LIB_H

#include "mbed.h"

#define WHO_AM_I 0x0F

#define CTRL_REG1 0x10
#define CTRL_REG2 0x11
#define CTRL_REG3 0x12
#define FIFO_CTRL 0x14

#define P_XL 0x28
#define P_L 0x29
#define P_H 0x2A

#define T_L 0x2B
#define T_H 0x2C

class pqLPS22HB_lib{
    
/**********
コンストラクタ
・AD0がHIGHかLOWかを選択
・使用するI2Cを選択

ex) pqLPS22HB_lib myLPS22HB(pqLPS22HB_lib :: AD0_LOW, I2C);
**********/
    public:
    typedef enum{
        AD0_LOW = 0xB8,
        AD0_HIGH = 0xBA
    }AD0;
    pqLPS22HB_lib(AD0 ad0, I2C &userI2C);
    private:
    char slave;
    I2C *i2c;

/**********
センサー起動（void）
・データ更新レートを選択（1, 10, 25, 50, 75）
**********/
    public:
    void begin(int drate);
    private:
    char cmd_ctrl_reg1[2];

/**********
FIFO設定（void）（未実装）
・モードを選択（したい）
・FIFO ウォーターマークレベルを選択（したい）
**********/
    public:
    void setFIFO();
    private:
    char cmd_ctrl_reg2[2];
    char cmd_ctrl_reg3[2];
    char cmd_fifo_ctrl[2];

/**********
Who Am I（int）
接続できているかを判定
接続OK：0
接続NG：-1
**********/
    public:
    int whoAmI();
    private:
    char cmd_who_am_i[1];
    
/**********
気圧を取得（float）
**********/
    public:
    float getPres();
    private:
    char cmd_p[3];
    int data_p[3];

/**********
温度を取得（float）
**********/
    public:
    float getTemp();    
    private:
    char cmd_t[2];
    int data_t[2];
    
/**********
高度を取得（float）
・引数に0m地点での気圧・温度を入れる
・計算式のソース：http://www.geocities.jp/u4ren6/Main/Excel_Data0017.html
**********/
    public:
    float getAlt(float P_0, float T_0);
    private:
    float pres_0;
    float temp_0;
    float pres_now;
    
/**********
高度を取得（float）
※温度の高度による変化を考慮
※こちらを推奨
・引数に0m地点での気圧・温度を入れる
・計算式のソース：http://zakii.la.coocan.jp/physics/31_pressure.htm
**********/
    public:
    float getAlt2(float P_0, float T_0);
    private:
    float pres;
};

#endif
