/*
XbeeAPI用シリアル通信ライブラリ
*/
#include "mbed.h"
#include <string>

#ifndef _XbeeApiLib_h
#define _XbeeApiLib_h

class XbeeApi{
    
    class Address{
        public:
            char ADR[8];
            char ADR16bit[2];
            bool IsAvailable;
            char sum;
    };
    public:
        XbeeApi(PinName Tx, PinName Rx, int BaudRate, void (*onPacketDataReceived)(int, char*));
        void SetAddress(int Num, unsigned long HIGH, unsigned long LOW);
        void StartPacket(char StartWith);
        void Write(string val);
        void Write(int val);
        void Write(long long val);
        void Write(double val);
        void Write(float val);
        void EndPacket();
        void ClearPacket();
        
        void SetInterrupt(bool val);
        void OnDataReceived();
        
        void OnTransmitEnabled();
        
        int HopLimit;
        
        //パケット受信時に呼ばれる関数
        void (*OnPacketReceived)(int, char*);
        
    private:
        int CheckSum;
        char buf[128];
        int ReceivedBytesCounter;
        char RxBuf[256];
        int itr;
        int BytesToTransmit;
        int NextTransmitIndex;
        int TransmittingAddrNum;
        bool IsTransmitting;
        
        void WriteWithEsc(char c);
        
        Address address[4];
        Serial Xbee;
};


#endif