/*
* XbeeでApi通信を行うライブラリの使用例
* コメントは全てXbeeApiLib関係の内容
*/

#include "mbed.h"
#include "XbeeApiLib.h"     // XbeeApiLib のインクルード

DigitalOut led1(LED1);

// パケット受信時に呼ばれてほしい関数のプロトタイプ宣言    Length: データ長   *message: データ
void OnXbeeDataReceived(int Length, char *message);


int main()
{
    // XbeeApi 「好きな名前」(TxPin, RxPin, ボーレート, パケット受信時に呼ばれてほしい関数)
    XbeeApi xbee(p13, p14, 115200, OnXbeeDataReceived);
    
    // 0番目の宛先アドレス
    xbee.SetAddress(0, 0x0013A200, 0x40A88F02);
    // 1番目の宛先アドレス
    xbee.SetAddress(1, 0x0013A200, 0x40E7D43E);
    // 2番目の宛先アドレス
    xbee.SetAddress(2, 0x0013A200, 0x40E7D44F);
    
    led1 = false;
    
    while(true){
        /*
        * XbeeApi::StartPacket(char Header) に渡す数字は XbeeApiで定められたものではなく
        * 単に地上局側でデータのフォーマットを判別するためのものなので
        * どの数字にどのフォーマットを当てはめるかはmainのプログラムを書く人が勝手に決めて良い
        * ただし0x00は非推奨 (パケットが128バイトを超えそうになった時にエラーとして0x00が使用されるため)
        */
        xbee.StartPacket(0x11);     // ヘッダー0x11のパケットの準備 この数字は任意のものを書き込んでよい
        xbee.Write(1);           // 上で用意したパケットにint型の数値を書き込む
        xbee.Write(0.5f);           // 上で用意したパケットにfloat型の数値を書き込む
        xbee.Write(0.5);           // 上で用意したパケットにdouble型の数値を書き込む
        xbee.EndPacket();   // パケットを送信
        wait(0.05);
    }
}

// パケット受信時の処理    Length: データ長   *message: データ
void OnXbeeDataReceived(int Length, char *message){
    led1 = !led1;
}
