#ifndef SERVO_H_
#define SERVO_H_
#include "mbed.h"

/**
* @author Matsumoto Gaku
* @note サーボモーターを回すライブラリです。0~180度のやつを対象としています。
*/
class   Servo{
    
    public:
        /**
           @param  _pin    pin's name
           @param  _maxPulse   Max pulse width in seconds
           @param  _minPulse   min pulse width in seconds
        */
        Servo(PinName pin, double maxPulse = 0.00245f, double minPulse = 0.00065f);
        
        /**
           @bref  rotate servo motor's horn set angle 
           @param  _angle[double]  Servo position in degree
        */
        void write(double angle);
        
        /**
           @bref  read current servo position
           @param  [double] Return angle in degree
        */
        double read();
        
        /**
           @bref  Set pulse width in max and min
           @param  maxPulse [double]   Max pulse width in seconds
           @param  minPulse [double]   min pulse width in seconds
        */
        void setRange(double maxPulse, double minPulse);
        
        /**
           @bref  Set pulse width in zero [degree]
           @param  zeroPulse [double]  pulse width in zero position
        */
        void setZeroPulse(double zeroPulse = 0.00160f);
        
        /**
           @bref  Set never over angle
           @param  maxAngle [double]   max servo position
           @param  minAngle [double]   min servo position
           @note   もし90,0と設定すると,絶対に0°から90°の範囲から出なくなります
        */
        void setAngleRange(double maxAngle = 90.0f, double minAngle = -90.0f);
        
        /**
           @bref  use '=' operater, you can write()
           @param  dValue [double]  angle in degree
        */
        Servo& operator= (double dValue);
       
        /**
           @bref  Return currnet angle, so the same of read()
        */
        double operator()(void);
       
    private:
        
        PwmOut _pwm;
        double currentAngle;
        double _maxPulse;
        double _minPulse;
        PinName _pinName;
        double _maxAngle;
        double _minAngle;
        double _zeroPulse;
};

#endif