#ifndef SHT35_H
#define SHT35_H

#define SLV_ADDR_HIGH   0b10001010
#define SLV_ADDR_LOW    0b10001000


class mySHT35
{
public:

        typedef enum AD0{
            AD0_HIGH = 1,
            AD0_LOW  = 0
        } AD0;

        mySHT35(I2C &i2cBus, AD0 celect = AD0_HIGH);
        
        void heaterSet(int i);//0ならヒーターOFF,1ならヒーターON
        
        void getTempHum(float *temp, float *hum);
        
        float getTemp();//二つまとめて受信するのと変わらない
        
        float getHum();//上に同じ
        
        int getState();
        
        void startContinueMeasure(int accuracy);
        void getContinueTempHum(float *temp, float *hum);
        void stopContinueMeasure();


private: 

        I2C *i2c;
        char _addr;
        char SLV_WRITE_SHT;
        char SLV_READ_SHT;
        float temp_p, hum_p;
        unsigned int val[4];
        char cmd[3], buff[6];
        int state_p;
        
};

#endif
        