#include"mbed.h"
#include"SHT35.h"

mySHT35::mySHT35(I2C &i2cBus, AD0 celect){
    i2c = &i2cBus;
    if(celect == AD0_HIGH){
        _addr = SLV_ADDR_HIGH;
    }
    else{
        _addr = SLV_ADDR_LOW;
    }
    SLV_WRITE_SHT = _addr;
    SLV_READ_SHT  = _addr | 1;    
    i2c -> frequency(400000);
}
/**********
ヒーターをセットする
i=0ならば、ヒーターOFF
i=1ならば、ヒーターON
セット直後は5msくらい待ってあげる
**********/

void mySHT35::heaterSet(int i)
{
    cmd[0] = 0x30;
    switch(i){
      case 0:
      cmd[1] = 0x66;
      break;
      
      case 1:
      cmd[1] = 0x6D;
      break;
      
      default:
      cmd[1] = 0x66;
    }
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
}
/**************
温度、湿度を取得する
このセンサーは温度、または湿度のデータを個別で送ることはできず
同時に送るので、一応個別に返す関数を作ったが、
なるべくこっちでまとめて値を取得した方がいいのかも
**************/
void mySHT35::getTempHum(float *temp, float *hum)
{
    cmd[0] = 0x24;
    cmd[1] = 0x00;
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
    wait_ms(30);
    i2c -> read(SLV_READ_SHT, buff, 6);
    
    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    val[2] = (unsigned int)buff[3] << 8;
    val[3] = (unsigned int)buff[4];
    
    temp_p = (float)(val[0] | val[1]);
    hum_p  = (float)(val[2] | val[3]);
    
    temp_p = temp_p * 175.0 / 65535 - 45.0;
    hum_p  = hum_p * 100.0 / 65535;
    
    if(temp_p > -273 && temp_p < 1000){
        *temp = temp_p;
    }
    if(hum_p > 0 && hum_p < 100){
        *hum = hum_p;
    }
}
/***********
温度を取得
湿度が絶対にいらない場合はこっちで
************/    
float mySHT35::getTemp()
{
    cmd[0] = 0x24;
    cmd[1] = 0x00;
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
    wait_ms(30);
    i2c -> read(SLV_READ_SHT, buff, 6);

    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    
    temp_p = (float)(val[0] | val[1]);
    temp_p = temp_p * 175.0 / 65535 - 45.0;

    return temp_p;
}
/***************
湿度を取得
温度が絶対にいらない場合はこちらで
*****************/
float mySHT35::getHum()
{
    cmd[0] = 0x24;
    cmd[1] = 0x00;
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
    wait_ms(30);
    i2c -> read(SLV_READ_SHT, buff, 6);

    val[0] = (unsigned int)buff[3] << 8;
    val[1] = (unsigned int)buff[4];
    
    hum_p = (float)(val[0] | val[1]);
    hum_p = hum_p * 100.0 / 65535;

    return hum_p;
}
/*************
センサーの現在の状態を取得
何bit目が何を表しているのかは
データシートを参照
*************/
int mySHT35::getState()
{
    cmd[0] = 0xF3;
    cmd[1] = 0x2D;
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
    i2c -> read(SLV_READ_SHT, buff, 2);
    
    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    
    state_p = (int)(val[0] | val[1]);
    if(state_p & 0b1000000000010000){
        return 1;
    }
    else{
        return state_p;
        //return 0;
    }
}

/****************
連続計測モード開始
引数で繰り返し精度を決める
 1 : 低
 2 : 中
 3 : 高
****************/
void mySHT35::startContinueMeasure(int accuracy){
    cmd[0] = 0x27;
    
    switch(accuracy){
        case 1:
        cmd[1] = 0x2A;  //繰り返し精度：低
        break;
        
        case 2:
        cmd[1] = 0x21;  //繰り返し精度：中
        break;
        
        case 3:
        cmd[1] = 0x37;  //繰り返し精度：高
        break;
        
        default:
        cmd[1] = 0x2A;  //繰り返し精度：低
    }
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
}

/*****************
連続計測モードデータ取得
*****************/
void mySHT35::getContinueTempHum(float *temp, float *hum){
    cmd[0] = 0xE0;
    cmd[1] = 0x00;
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
    i2c -> read(SLV_READ_SHT, buff, 6);
    
    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    val[2] = (unsigned int)buff[3] << 8;
    val[3] = (unsigned int)buff[4];
    
    temp_p = (float)(val[0] | val[1]);
    hum_p  = (float)(val[2] | val[3]);
    
    temp_p = temp_p * 175.0 / 65535 - 45.0;
    hum_p  = hum_p * 100.0 / 65535;
    
    if(temp_p > -273 && temp_p < 1000){
        *temp = temp_p;
    }
    if(hum_p > 0 && hum_p < 100){
        *hum = hum_p;
    }
        
}

/****************
連続計測モード停止
****************/
void mySHT35::stopContinueMeasure(){
    cmd[0] = 0x30;
    cmd[1] = 0x93;
    
    i2c -> write(SLV_WRITE_SHT, cmd, 2);
}
