#include"mbed.h"
#include"SHT3x.h"

//Serial pc(USBTX, USBRX); //tx, rx

mySHT3x::mySHT3x(I2C &i2cBus, AD0 celect){
    i2c = &i2cBus;
    if(celect == AD0_HIGH) _addr = SLV_ADDR_HIGH;
    else _addr = SLV_ADDR_LOW;
    SLV_WRITE_SHT = _addr;
    SLV_READ_SHT  = _addr | 1;    
    i2c->frequency(400000);
}
/**********
ヒーターをセットする
i=0ならば、ヒーターOFF
i=1ならば、ヒーターON
セット直後は5msくらい待ってあげる
**********/

void mySHT3x::heater_set(int i)
{
    char cmd[2][2];
    cmd[0][0] = 0x30;cmd[0][1] = 0x66;
    cmd[1][0] = 0x30;cmd[1][1] = 0x6D;
    
    i2c->write(SLV_WRITE_SHT, cmd[i], 3);
}
/**************
温度、湿度を取得する
このセンサーは温度、または湿度のデータを個別で送ることはできず
同時に送るので、一応個別に返す関数を作ったが、
なるべくこっちでまとめて値を取得した方がいいのかも
**************/
void mySHT3x::get_temp_hum(float *temp, float *hum)
{
    char cmd[2] = {0x24,0x00};
    char buff[6];
    unsigned int val[4];
    
    i2c->write(SLV_WRITE_SHT, cmd, 2);
    wait_ms(30);
    i2c->read(SLV_READ_SHT, buff, 6);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    val[2] = (unsigned int)buff[3]<<8;
    val[3] = (unsigned int)buff[4];
    
    *temp = (float)(val[0] | val[1]);
    *hum  = (float)(val[2] | val[3]);
    
    *temp = *temp*175.0/65535-45.0;
    *hum  = *hum*100.0/65535;
}
/***********
温度を取得
湿度が絶対にいらない場合はこっちで
************/    
float mySHT3x::get_temp()
{
    char cmd[2] = {0x24,0x00};
    char buff[6];
    unsigned int val[2];
    float temp;
    
    i2c->write(SLV_WRITE_SHT, cmd, 2);
    //wait_ms(30);
    i2c->read(SLV_READ_SHT, buff, 6);

    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    temp = (float)(val[0] | val[1]);
    temp = temp*175.0/65535-45.0;

    return temp;
}
/***************
湿度を取得
温度が絶対にいらない場合はこちらで
*****************/
float mySHT3x::get_hum()
{
    char cmd[2] = {0x24,0x00};
    char buff[6];
    unsigned int val[2];
    float hum;
    
    i2c->write(SLV_WRITE_SHT, cmd, 2);
    //wait_ms(30);
    i2c->read(SLV_READ_SHT, buff, 6);

    val[0] = (unsigned int)buff[3]<<8;
    val[1] = (unsigned int)buff[4];
    
    hum = (float)(val[0] | val[1]);
    hum = hum*100.0/65535;

    return hum;
}
/*************
センサーの現在の状態を取得
何bit目が何を表しているのかは
データシートを参照
*************/
int mySHT3x::get_state()
{
    char cmd[2] = {0xF3, 0x2D};
    char buff[2];
    unsigned int val[2];
    int state;
    
    i2c->write(SLV_WRITE_SHT, cmd, 2);
    i2c->read(SLV_READ_SHT, buff, 2);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    state = (int)(val[0] | val[1]);  

    return state;
}
    

