#include "Nichrome_lib.h"
#include "mbed.h"

Nichrome_lib :: Nichrome_lib(PinName userPin) : nichrome(userPin){
    nlib = this;
    nichrome = 0;
    status = false;
}

void Nichrome_lib :: fire(float time){
    if(time <= 0.0f){
        return;
    }
    fire_on();
    stopTime.attach(nlib, &Nichrome_lib::fire_off, time);
}

void Nichrome_lib :: fire_on(){
    nichrome = 1;
    status = true;
}

void Nichrome_lib :: fire_off(){
    nichrome = 0;
    status = false;
}