#ifndef LPS25H_LIB_H
#define LPS25H_LIB_H

#include "mbed.h"

#define WHO_AM_I 0x0F

#define CTRL_REG1 0x20
#define CTRL_REG2 0x21
#define FIFO_CTRL 0x2E

#define P_XL 0x28
#define P_L 0x29
#define P_H 0x2A

#define T_L 0x2B
#define T_H 0x2C

class LPS25H_spi{
/**********
コンストラクタ
・使用するSPIを選択
・使用するCSピンを選択

ex) LPS25H_spi myLPS25H(SPI, p8);
**********/
    public:
    LPS25H_spi(SPI &userSPI, PinName userPin);
    private:
    SPI *spi;
    DigitalOut cs;
    
/**********
(void)センサー起動(int データレート)
・データ更新レートを選択（1, 10, 25, 50, 75）
**********/
    public:
    void begin(int drate);
    private:
    int cmd_ctrl_reg1;
    
/**********
(void)FIFO設定（int FIFOレベル）
・FIFOウォーターマークレベルを選択（2, 4, 8, 16, 32）
**********/
    public:
    void setFIFO(int size);
    private:
    int cmd_ctrl_reg2;
    int cmd_fifo_ctrl;
    
/**********
(int)Who Am I
接続できているかを判定
接続OK：1
接続NG：-1
**********/
    public:
    int whoAmI();
    private:
    int ans;
    
/**********
(float)気圧を取得
**********/
    public:
    float getPres();
    private:
    unsigned int pres_raw[3];
    
/**********
（float）温度を取得
**********/
    public:
    float getTemp();
    private:
    unsigned int temp_raw[2];
    
/**********
(float)高度を取得(float 0mでの気圧, float 0mでの温度)
・引数に0m地点での気圧・温度を入れる
・計算式のソース：http://www.geocities.jp/u4ren6/Main/Excel_Data0017.html
**********/
    public:
    float getAlt(float P_0, float T_0);
    private:
    float pres_0;
    float temp_0;
    float pres_now;
};

#endif