#include "LPS25H_lib.h"
#include "mbed.h"
#include "math.h"

LPS25H_lib :: LPS25H_lib(AD0 ad0, I2C &userI2C){
    slave = ad0;
    i2c = &userI2C;
}

void LPS25H_lib :: begin(int drate){
    cmd_ctrl_reg1[0] = CTRL_REG1;
    switch(drate){
        case 0:
        cmd_ctrl_reg1[1] = 0x80;
        break;
        
        case 1:
        cmd_ctrl_reg1[1] = 0x90;
        break;
        
        case 7:
        cmd_ctrl_reg1[1] = 0xA0;
        break;
        
        case 12:
        cmd_ctrl_reg1[1] = 0xB0;
        break;
        
        case 25:
        cmd_ctrl_reg1[1] = 0xC0;
        break;
    }
    
    i2c -> frequency(400000);
    i2c -> write(slave, cmd_ctrl_reg1, 2, true);
    wait(0.5f);
}

void LPS25H_lib :: setFIFO(int size){
    cmd_ctrl_reg2[0] = CTRL_REG2;
    cmd_ctrl_reg2[1] = 0x40;
    cmd_fifo_ctrl[0] = FIFO_CTRL;
    switch(size){
        case 0:
        cmd_ctrl_reg2[1] = 0x00;
        cmd_fifo_ctrl[1] = 0x00;
        break;
        
        case 2:
        cmd_fifo_ctrl[1] = 0xC1;
        break;
        
        case 4:
        cmd_fifo_ctrl[1] = 0xC3;
        break;
        
        case 8:
        cmd_fifo_ctrl[1] = 0xC7;
        break;
        
        case 16:
        cmd_fifo_ctrl[1] = 0xCF;
        break;
        
        case 32:
        cmd_fifo_ctrl[1] = 0xDF;
        break;
    }
    
    i2c -> write(slave, cmd_ctrl_reg2, 2, true);
    i2c -> write(slave, cmd_fifo_ctrl, 2, true);
    wait(0.5f);
}

int LPS25H_lib :: whoAmI(){
    cmd_who_am_i[0] = WHO_AM_I;
    i2c -> write(slave, cmd_who_am_i, 1, true);
    i2c -> read(slave | 1, &cmd_who_am_i[0], 1, false);
    if(cmd_who_am_i[0] == 0xBD){
        return 0;
    }
    else{
        return -1;
    }
}

float LPS25H_lib :: getPres(){
    cmd_p[0] = P_XL;
    cmd_p[1] = P_L;
    cmd_p[2] = P_H;
    for(int c1 = 0; c1 < 3; c1 ++){
        i2c -> write(slave, &cmd_p[c1], 1, true);
        i2c -> read(slave | 1, &cmd_p[c1], 1, false);
        data_p[c1] = (int)cmd_p[c1];
    }
    return (float)(data_p[0] | data_p[1] << 8 | data_p[2] << 16) / 4096.0f;
}

float LPS25H_lib :: getTemp(){
    cmd_t[0] = T_L;
    cmd_t[1] = T_H;
    for(int c1 = 0; c1 < 2; c1 ++){
        i2c -> write(slave, &cmd_t[c1], 1, true);
        i2c -> read(slave, &cmd_t[c1], 1, false);
        data_t[c1] = (int)cmd_t[c1];
    }
    if(data_t[1] >= 128){
        return 42.5 - (float)(65536 - (data_t[0] | data_t[1] << 8)) / 480.0f;
    }
    else{
        return 42.5 + (float)(data_t[0] | data_t[1] << 8) / 480.0f;
    }
}

float LPS25H_lib :: getAlt(float P_0, float T_0){
    pres_0 = P_0;
    temp_0 = T_0;
    pres_now = getPres();
    
    return -(273.0 + temp_0) / 0.0342 * log(pres_now / pres_0);
}