#ifndef LPS25H_LIB_H
#define LPS25H_LIB_H

#include "mbed.h"

#define WHO_AM_I 0x0F

#define CTRL_REG1 0x20
#define CTRL_REG2 0x21
#define FIFO_CTRL 0x2E

#define P_XL 0x28
#define P_L 0x29
#define P_H 0x2A

#define T_L 0x2B
#define T_H 0x2C

class LPS25H_lib{
    
    public:
    typedef enum{
        AD0_LOW = 0xB8,
        AD0_HIGH = 0xBA
    }AD0;
    LPS25H_lib(AD0 ad0, I2C &userI2C);
    private:
    char slave;
    I2C *i2c;
    
    public:
    void begin(int drate);
    private:
    char cmd_ctrl_reg1[2];
    
    public:
    void setFIFO(int size);
    private:
    char cmd_ctrl_reg2[2];
    char cmd_fifo_ctrl[2];
    
    public:
    int whoAmI();
    private:
    char cmd_who_am_i[1];
    
    public:
    float getPres();
    private:
    char cmd_p[3];
    int data_p[3];
    
    public:
    float getTemp();
    private:
    char cmd_t[2];
    int data_t[2];
    
    public:
    float getAlt(float P_0, float T_0);
    private:
    float pres_0;
    float temp_0;
    float pres_now;
};

#endif