#ifndef _LPS25H_H_
#define _LPS25H_H_

#define SLV_READ    0xBB
#define SLV_WRITE   0xBA


#define REF_P_XL    0x08
#define REF_P_L     0x09
#define REF_P_H     0x0A
#define WHO_AM_I    0x0F
#define RES_CONF    0x10

#define CTRL_REG1   0x20
#define CTR_REG2    0x21
#define CTR_REG3    0x22
#define CTR_REG4    0x23
#define INT_CFG     0x24
#define INT_SOURCE  0x25

#define STATUS_REG  0x27
#define PRESS_OUT_XL    0x28
#define PRESS_OUT_L 0x29
#define PRESS_OUT_H 0x2A
#define TEMP_OUT_L  0x2B
#define TEMP_OUT_G  0x2C

#define FIFO_CTRL   0x2E
#define FIFO_STATUS 0x2F
#define THS_P_L     0x30
#define THS_P_H     0x31

#define RPDS_L      0x39
#define RPDS_H      0x3A

//I2C i2c(PB_7, PB_6);    // sda, scl
//Serial pc(USBTX, USBRX); //tx, rx
    
class MyLPS25H
{
public:

    MyLPS25H(PinName SDA, PinName SCL); 
    //void I2C i2c(char SDA, char SCL);
    void SetPress();    //LPS25Hのセットアップ
    float GetPress();   //気圧データの取得
    
private:
    float Pressure;
    unsigned long Press_XL, Press_L, Press_H;
    char cmd[2], cmd_XL[2], cmd_L[2], cmd_H[2];
    char check[1];
    PinName _SDA;
    PinName _SCL;
};


#endif  //_LPS25H_H_
        




