#include "mbed.h"
#include "LPS25H.h"


//Serial pc(USBTX, USBRX); //tx, rx


MyLPS25H::MyLPS25H(PinName SDA, PinName SCL) : _SDA(SDA), _SCL(SCL){
   // I2C i2c(_SDA, _SCL);
    }

void MyLPS25H::SetPress()
{
    I2C i2c(_SDA, _SCL);    // sda, scl
    char cmd[2];
    cmd[0] = WHO_AM_I;
    i2c.write(SLV_WRITE, cmd, 1);
    i2c.read(SLV_READ, cmd, 1);
    char check[1];
    check[0] = 0xBD;

        
    if(cmd[0] == check[0]){
        //pc.printf("LPS25H   OK\r\n");
    }else{
        //pc.printf("LPS25H   NG\r\n");
    }        
    
    cmd[0] = CTRL_REG1;
    cmd[1] = 0xC0;
    i2c.write(SLV_WRITE, cmd, 2);
}

float MyLPS25H::GetPress()
{
    I2C i2c(_SDA, _SCL);    // sda, scl
    //char cmd[2];
    char cmd_H[2];
    char cmd_L[2];
    char cmd_XL[2];
    float Pressure = 0;
        
    while(1)
    {
        
    cmd_XL[0] = PRESS_OUT_XL;
    i2c.write(SLV_WRITE, cmd_XL, 1);
    i2c.read(SLV_READ, cmd_XL, 1);
    
    cmd_L[0] = PRESS_OUT_L;
    i2c.write(SLV_WRITE, cmd_L, 1);
    i2c.read(SLV_READ, cmd_L, 1);
    
    cmd_H[0] = PRESS_OUT_H;
    i2c.write(SLV_WRITE, cmd_H, 1);
    i2c.read(SLV_READ, cmd_H, 1);
    
    unsigned long Press_H = 0, Press_L = 0, Press_XL = 0;
    Press_XL = (long)cmd_XL[0];
    Press_L = (long)cmd_L[0];
    Press_H = (long)cmd_H[0];
   // Pressure = (cmd_H[0]<<20 | cmd_H[1]<<16 | cmd_L[0]<<12 | cmd_L[1]<<8 | cmd_XL[0]<<4 | cmd_XL[1])/4096;
    Pressure = (float)(Press_H << 16 | Press_L << 8 | Press_XL);
    return Pressure/4096;
    }
    
}
    