#ifndef INA226_H
#define INA226_H

#define check_reg        0xFE
#define Ctrl_reg         0x00
#define V_shunt_reg      0x01
#define V_bus_reg        0x02
#define power_reg        0x03
#define current_reg      0x04
#define cal_reg          0x05

//I2C i2c(PB_7, PB_6);    // sda, scl
//Serial pc(USBTX, USBRX); //tx, rx

/**
*  @bref  INA226 Class
*  @author Seiya Maemura
*/


class myINA226
{
public:

        typedef enum A1{
            A1_GND = 0,
            A1_VDD = 1,
            A1_SDA = 2,
            A1_SCL = 3
        } A1;
        
        typedef enum A0{
            A0_GND = 0,
            A0_VDD = 1,
            A0_SDA = 2,
            A0_SCL = 3
        } A0;
        
        /***********************************************************************
        A1,A0はそれぞれはんだでジャンパして選択します
        このA1,A0の組み合わせでスレーブアドレスを決定します
        
        @example
        A1:GND,A0:GND → SLAVE_ADDR:0b10000000
        ***********************************************************************/

        myINA226(I2C &i2cBus,A1 celect_1 = A1_GND, A0 celect_0 = A0_GND);
        /***********************************************************************
        第一、第二引数がないとスレーブアドレスが0b10000000になるようになっている

        ***********************************************************************/
        
        void set_callibretion(unsigned int val = 0x0AAA);
        /***********************************************************************
        電流を取得したいときに必要
        これをセットしないと電流は取れない

        @example

            float current;
   
            myINA226.set_callibretion();
            current = myINA226.get_current();
        ***********************************************************************/
        
        int Connection_check();
        /***********************************************************************
        INA226の接続確認
        0が返ってくればOK
        1が返ってくればError
        ***********************************************************************/
        
        void setup(int i);
        /***********************************************************************
        シャント抵抗の電圧(よくわかんない)か,測りたい電圧の値、またはその両方の値を
        取得するかどうかを決める
        i=0のとき、両方の値を取得
        i=1のとき、測りたい方の電圧のみ取得
        i=2のとき、シャント抵抗の電圧のみ取得
        印加電圧は測りたい方の電圧なので基本的にはi=1
        デフォルトでは、両方の値を取得できるようになっている
        ***********************************************************************/
        
        void get_Voltage_current(float *V_bus, float *current);
        /***********************************************************************
        INA226で測定したいだろう電圧と電流の値を
        まとめて取得する
        もしsetupでi=2、つまりシャント抵抗の電圧の値だけを取得するようにしていたら
        事前にi=0 or 1に設定しておかなければならない

        @example

            float V_bus,current;
    
            myINA226.setup(0) or myINA226.setup(1);
            myINA226.get_Voltage_current(&V_bus,&current);
        ***********************************************************************/
        
        float get_Shunt_voltage();
        /***********************************************************************
        シャント抵抗の電圧の値を取得
        もしsetupでi=1、つまり印加電圧の値だけを取得するようにしていたら
        事前にi=0 or 2に設定しておかなければならない

        @example

            float V_shunt;
    
            myINA226.setup(0) or myINA226.setup(2);
            V_shunt = myINA226.get_Shunt_voltage();
        ***********************************************************************/
        
        float get_Bus_voltage();
        /***********************************************************************
        印加電圧の値を取得
        もしsetupでi=2、つまりシャント抵抗の電圧の値だけを取得するようにしていたら
        事前にi=0 or 1に設定しておかなければならない

        @example

        　　　float V_bus;
    
            myINA226.setup(0) or myINA226.setup(1);
            V_bus = myINA226.get_Bus_voltage();
        ***********************************************************************/
        
        float get_current();
        /***********************************************************************
        電流の値を取得
        事前にset_callibretionをセットしておかないと
        0しか返ってこない
        @example

           float current;
   
           myINA226.set_callibretion();
           current = myINA226.get_current();
        ***********************************************************************/
        
        float get_power();
        /***********************************************************************
        電力の値を取得
        事前にset_callibretionをセットしておかないと
        0しか返ってこない
        
        @example

           float power;
   
           myINA226.set_callibretion();
           power = myINA226.get_power();
        ***********************************************************************/
        
        
private: 

        I2C *i2c;
        char _addr_1,_addr_0,_addr;
        char SLV_WRITE_INA;
        char SLV_READ_INA;
        float vlotage,current;
        unsigned int val[4];
        char *cal,buff[4],reg,check[2];
};

#endif