#include"mbed.h"
#include"INA226.h"

//Serial pc(USBTX, USBRX); //tx, rx

myINA226::myINA226(I2C &i2cBus,A1 celect_1,A0 celect_0){
    i2c = &i2cBus;
    
    if(celect_1 == A1_GND)         _addr_1 = 0b10000000;
    else if(celect_1 == A1_VDD)    _addr_1 = 0b10001000;
    else if(celect_1 == A1_SDA)    _addr_1 = 0b10010000;
    else if(celect_1 == A1_SCL)    _addr_1 = 0b10011000;
    
    if(celect_0 == A0_GND)         _addr_0 = 0b00000000;
    else if(celect_0 == A0_VDD)    _addr_0 = 0b00000010;
    else if(celect_0 == A0_SDA)    _addr_0 = 0b00000100;
    else if(celect_0 == A0_SCL)    _addr_0 = 0b00000110;
    
    _addr = _addr_1 | _addr_0;
    SLV_WRITE_INA = _addr;
    SLV_READ_INA  = _addr | 1;    
    i2c->frequency(400000);
}

/************
電流を取得したいときに必要
これをセットしないと電流は取れない

@example

   float current;
   
   myINA226.set_callibretion();
   current = myINA226.get_current();
************/
void myINA226::set_callibretion(unsigned int val)
{
    char reg = cal_reg;
    char cmd[3];
    cmd[0] = reg;
    cmd[1] = static_cast<char>(val>>8 & 0x00FF);
    cmd[2] = static_cast<char>(val & 0x00FF);
    
    i2c->write(SLV_WRITE_INA, cmd, 3);
}

/*************
INA226の接続確認
0が返ってくればOK
1が返ってくればError
*************/
int myINA226::Connection_check()
{
    char reg = check_reg;
    char check[2];
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    i2c->read(SLV_READ_INA, check, 2);
    
    if(check[0] == 0x54 && check[1] == 0x49){return 0;}
    else{return 1;}
}
/*************
シャント抵抗の電圧か,印加電圧の値、またはその両方の値を
取得するかどうかを決める
i=0のとき、両方の値を取得
i=1のとき、印加電圧のみ取得
i=2のとき、シャント抵抗の電圧のみ取得
印加電圧が測りたい電圧なので基本的にはi=1
デフォルトでは、両方の値を取得できるようになっている
*************/
void myINA226::setup(int i)
{
    char reg = Ctrl_reg;
    char cmd[3][3];
    int j;
    
    for(j=0;j<3;j++){cmd[j][0]=reg; cmd[j][1]=0x41;}
    cmd[0][2]=0xFF;cmd[1][2]=0xFE;cmd[2][2]=0xFD;
    
    i2c->write(SLV_WRITE_INA, cmd[i], 3);
}
/*******************
INA226で測定したいだろう電圧と電流の値を
まとめて取得する
もしsetupでi=2、つまりシャント抵抗の電圧の値だけを取得するようにしていたら
事前にi=0 or 1に設定しておかなければならない

@example

    float V_bus,current;
    
    myINA226.setup(0) or myINA226.setup(1);
    myINA226.get_Voltage_current(&V_bus,&current);
*******************/
void myINA226::get_Voltage_current(float *V_bus, float *current)
{
    char reg = V_bus_reg;
    char buff[2];
    unsigned int val[2];
    
    //setup(0);
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    //wait_ms(10);
    i2c->read(SLV_READ_INA, buff, 2, false);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    *V_bus = (float)(val[0] | val[1]);
    *V_bus = *V_bus*1.25;
    
    reg = current_reg;
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    //wait_ms(10);
    i2c->read(SLV_READ_INA, buff, 2, false);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    *current = (float)(val[0] | val[1]);
    *current = *current;//1.25;
}
/**************
シャント抵抗の電圧の値を取得
もしsetupでi=1、つまり印加電圧の値だけを取得するようにしていたら
事前にi=0 or 2に設定しておかなければならない

@example

    float V_shunt;
    
    myINA226.setup(0) or myINA226.setup(2);
    V_shunt = myINA226.get_Shunt_voltage();
**************/
float myINA226::get_Shunt_voltage()
{
    char reg = V_shunt_reg;
    char buff[2];
    unsigned int val[2];
    float V_shunt;
    
    //setup(2);
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    //wait_ms(10);
    i2c->read(SLV_READ_INA, buff, 2, false);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    V_shunt = (float)(val[0] | val[1]);
    V_shunt = V_shunt*1.25;

    return V_shunt;
}
/**************
印加電圧の値を取得
もしsetupでi=2、つまりシャント抵抗の電圧にの値だけを取得するようにしていたら
事前i=0 or 1に設定しておかなければならない

@example

　　　float V_bus;
    
    myINA226.setup(0) or myINA226.setup(1);
    V_bus = myINA226.get_Bus_voltage();
**************/
float myINA226::get_Bus_voltage()
{
    char reg = V_bus_reg;
    char buff[2];
    unsigned int val[2];
    float V_bus;
    
    //setup(1);
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    //wait_ms(10);
    i2c->read(SLV_READ_INA, buff, 2, false);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    V_bus = (float)(val[0] | val[1]);
    V_bus = V_bus*1.25;

    return V_bus;
}
/***********
電流の値を取得
事前にset_callibretionをセットしておかないと
0しか返ってこない
@example

   float current;
   
   myINA226.set_callibretion();
   current = myINA226.get_current();
************/
float myINA226::get_current()
{

    char reg = current_reg;
    char buff[2];
    unsigned int val[2];
    float current;
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    //wait_ms(10);
    i2c->read(SLV_READ_INA, buff, 2, false);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    current = (float)(val[0] | val[1]);
    current = current;//*1.25;

    return current;
}
/***********
電力の値を取得
事前にset_callibretionをセットしておかないと
0しか返ってこない
@example

   float power;
   
   myINA226.set_callibretion();
   power = myINA226.get_power();
************/
float myINA226::get_power()
{
    char reg = power_reg;
    char buff[2];
    unsigned int val[2];
    float power;
    
    i2c->write(SLV_WRITE_INA, &reg, 1);
    //wait_ms(10);
    i2c->read(SLV_READ_INA, buff, 2, false);
    
    val[0] = (unsigned int)buff[0]<<8;
    val[1] = (unsigned int)buff[1];
    
    power = (float)(val[0] | val[1]);

    return power;
}
