#include "mbed.h"
#include "mpu9250_i2c.h"
#define NINE_SDA p28
#define NINE_SCL p27

I2C i2cBus(p28, p27);
mpu9250 nine(i2cBus, AD0_HIGH);
Serial pc(USBTX, USBRX);

int main() {
    
    double imu[6] = {0};
    double mag[3] = {0};
    
    pc.baud(115200);
    
    nine.setAccLPF(NO_USE);
    nine.setGyro(_1000DPS);
    nine.setAcc(_8G);
    nine.setOffset(0.0f, 0.0f, 0.0f,
                   0.0f, 0.0f, 0.0f,
                   0.0f, 0.0f, 0.0f);
    while(1) {
        nine.getGyroAcc(imu);
        nine.getMag(mag);
        pc.printf("%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\r\n",imu[0],imu[1],imu[2],imu[3],imu[4],imu[5],mag[0],mag[1],mag[2]);
    }
}
