#include "mbed.h"
#include "GPS_interrupt.h"
RawSerial pc(USBTX, USBRX);
//RawSerial mygps(p28, p27);

#define FIRST_BAUDRATE 9600
#define BAUDRATE 115200

//GPS_interrupt *gps;
//GPS_interrupt gps(&mygps, 10);
Serial mygps(D1, D0,115200);
GPS_interrupt gps(&mygps);//, 10);

void bootFunction(){
    pc.printf("\r\n");
    pc.printf("start LPC1768 boot phase\r\n");
    wait(0.5);
    for(int i = 0;i < 100;i++){
        pc.printf("Loading... : %3d [%%]\r", i);
        wait(0.025);
    }
    pc.printf("Loading... : %3d [%%]\r\n", 100);
    pc.printf("\t-> finished!!\r\n");
    pc.printf("System : %d Hz\r\n", SystemCoreClock );
    wait(0.5);
    pc.printf("start main program\r\n");
    wait(0.1);
    pc.printf("initialize");
    wait(0.75);
    pc.printf(" -> OK\r\n");
    wait(0.1);
    pc.printf("GPS Connecting");
    wait(0.5);
    pc.printf(".");
    wait(0.5);
    pc.printf(".");
    wait(0.5);
    pc.printf(".");
    wait(0.5);
    pc.printf(".");
    wait(0.5);
    pc.printf(".");
    wait(0.5);
    pc.printf(".");
 
    wait(0.5);
}

int main() {
    
    pc.baud(115200);
    
    bootFunction();
    wait(0.5);
    gps.gps_readable = false;
    gps.debug(true);
    while(!gps.gps_readable){
        if(pc.readable())   break;   
    }
    pc.printf(" -> OK\r\n");
    pc.printf("start!!\r\n\r\n");
    while(1){
        double xy[2] = {0};
        float utc[6] = {0};
        if(gps.gps_readable){
            gps.debug(false);
            gps.gps_readable = false;
            gps.getPosition(xy);
            gps.getUTC(utc);
            pc.printf("\033[K");
            pc.printf("%d/%d/%d %d:%d:%02.2f ",(int)utc[0],(int)utc[1], (int)utc[2], (int)utc[3], (int)utc[4] ,utc[5]); 
            pc.printf("(%3.7fe,%3.7fn) ",xy[0], xy[1]);
            pc.printf("%d satellites, %.2f[m], %.3f[m/s], %3.2f[degree]\r", gps.Number(), gps.Height(), gps.Knot()*1852.0/3600.0, gps.Degree());   
            wait(0.1);
        }
        else gps.debug(true);
    }
}
