#include "mbed.h"

#include "PQ_ES920.h"

#define ADXL375_LSB 0.049
#define INA226_VOLTAGE_LSB 1.25
#define INA226_CURRENT_LSB 1.25
#define LPS22HB_PRESS_LSB 4096.0
#define LPS22HB_TEMP_LSB 0.01
#define MPU9250_ACCEL_LSB 0.0000610
#define MPU9250_GYRO_LSB 0.00763

Serial pc(USBTX, USBRX, 115200);
Serial es_serial(PA_9, PA_10, 115200);

ES920 es(es_serial);

void downlink_handler(char* data);

int main()
{
    es.attach(downlink_handler);
    pc.printf("PLANET-Q GROUND STATION\r\n");

    while(1) {
        if(pc.readable()) {
            char command[1];
            command[0] = pc.getc() + 0x80;
            if(command[0] == 0xE2){
                es.send(command, 1);
                pc.printf("send:\t%02x\r\n", command[0]);
            }
        }
    }
}

void downlink_handler(char *data)
{
    short mission_time_bits = *(short*)&data[0];
    short flight_time_bits = *(short*)&data[2];
    char phase = data[4];
    char use_apogee = data[5] >> 7 & 1;
    char apogee     = data[5] >> 6 & 1;
    char landed     = data[5] >> 5 & 1;
    char signal     = data[5] >> 4 & 1;
    char mission    = data[5] >> 3 & 1;
    char relay      = data[5] >> 2 & 1;
    char sep        = data[5] >> 1 & 1;
    char buzzer     = data[5] >> 0 & 1;
    char flight    = data[6] >> 7 & 1;
    char f_sd      = data[6] >> 6 & 1;
    char f_gps     = data[6] >> 5 & 1;
    char f_adxl    = data[6] >> 4 & 1;
    char f_ina_in  = data[6] >> 3 & 1;
    char f_ina_ex  = data[6] >> 2 & 1;
    char f_lps     = data[6] >> 1 & 1;
    char f_mpu     = data[6] >> 0 & 1;
    int lat_bits = *((int*)&data[7]);
    int lon_bits = *((int*)&data[11]);
    int alt_bits = *((int*)&data[15]);
    short high_accel_bits[3];
    high_accel_bits[0] = *(short*)&data[19];
    high_accel_bits[1] = (short)(data[21] | data[22] << 8);
    high_accel_bits[2] = (short)(data[23] | data[24] << 8);
    short voltage_in_bits = (short)(data[25] | data[26] << 8);
    short current_in_bits = (short)(data[27] | data[28] << 8);
    short voltage_ex_bits = (short)(data[29] | data[30] << 8);
    short current_ex_bits = (short)(data[31] | data[32] << 8);
    int press_bits = (int)(data[33] | data[34] << 8 | data[35] << 16);
    short temp_bits = (short)(data[36] | data[37] << 8);
    short accel_bits[3];
    accel_bits[0] = (short)(data[38] | data[39] << 8);
    accel_bits[1] = (short)(data[40] | data[41] << 8);
    accel_bits[2] = (short)(data[42] | data[43] << 8);
    short gyro_bits[3];
    gyro_bits[0] = (short)(data[44] | data[45] << 8);
    gyro_bits[1] = (short)(data[46] | data[47] << 8);
    gyro_bits[2] = (short)(data[48] | data[49] << 8);

    short mission_time = mission_time_bits;
    float flight_time = flight_time_bits / 10.0f;
    float lat = *((float*)&lat_bits);
    float lon = *((float*)&lon_bits);
    float alt = *((float*)&alt_bits);
    float high_accel[3];
    for(int i = 0; i < 3; i++) {
        high_accel[i] = high_accel_bits[i] * (ADXL375_LSB * 8);
    }
    float voltage_in = voltage_in_bits * INA226_VOLTAGE_LSB;
    float current_in = current_in_bits * INA226_CURRENT_LSB;
    float voltage_ex = voltage_ex_bits * INA226_VOLTAGE_LSB;
    float current_ex = current_ex_bits * INA226_CURRENT_LSB;
    float press = press_bits / LPS22HB_PRESS_LSB;
    float temp = temp_bits * LPS22HB_TEMP_LSB;
    float accel[3];
    for(int i = 0; i < 3; i++) {
        accel[i] = accel_bits[i] * (MPU9250_ACCEL_LSB * 8);
    }
    float gyro[3];
    for(int i = 0; i < 3; i++) {
        gyro[i] = gyro_bits[i] * (MPU9250_GYRO_LSB * 8);
    }

    int mission_hour = mission_time / 3600;
    mission_time %= 3600;
    int mission_min = mission_time / 60;
    mission_time %= 60;
    int mission_sec = mission_time;
    
    int lat_degree = (int)lat;
    int lon_degree = (int)lon;
    int lat_minute = (int)((lat - (int)lat) * 60);
    int lon_minute = (int)((lon - (int)lon) * 60);
    float lat_second = ((lat - (int)lat) * 60 - (int)((lat - (int)lat) * 60)) * 60;
    float lon_second = ((lon - (int)lon) * 60 - (int)((lon - (int)lon) * 60)) * 60;

    char *phase_names[] =  {"SAFETY", "READY", "FLIGHT", "SEP", "EMERGENCY", "RECOVERY"};

    pc.printf(" PLANET-Q GROUND STATION\r\n");
    pc.printf(" commands:\r\n");
    pc.printf(" 0   : SAFETY\r\n");
    pc.printf(" 1   : READY\r\n");
    pc.printf(" 2   : FLIGHT\r\n");
    pc.printf(" 3   : SEP\r\n");
    pc.printf(" 4   : EMERGENCY\r\n");
    pc.printf(" 5   : RECOVERY\r\n");
    pc.printf(" DEL : SYSTEM RESET\r\n");
    pc.printf("\r\n");
    pc.printf(" mission time:\t%02d:%02d:%02d\r\n", mission_hour, mission_min, mission_sec);
    pc.printf(" flight time:\t%.3f[s]\r\n", flight_time);
    pc.printf(" phase:\t%s\r\n", phase_names[phase]);
    pc.printf(" flags:\tUSE_APG\tAPOGEE\tLANDED\tSIGANL\tMISSION\tRELAY\tSEP\tBUZZER\r\n");
    pc.printf("       \t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\r\n", use_apogee, apogee, landed, signal, mission, relay, sep, buzzer);
    pc.printf(" flags:\tFLIGHT\tSD\tGPS\tADXL\tINA_in\tINA_ex\tLPS\tMPU\r\n");
    pc.printf("       \t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\r\n", flight, f_sd, f_gps, f_adxl, f_ina_in, f_ina_ex, f_lps, f_mpu);
    pc.printf("\r\n");
    pc.printf(" lat:\t\t%.6f\r\n", lat);
    pc.printf(" lon:\t\t%.6f\r\n", lon);
    pc.printf(" alt:\t\t%.1f[m]\r\n", alt);
    pc.printf("\r\n");
    
    pc.printf(" lat:\t\t%d度%d分%.4f秒\r\n", lat_degree, lat_minute, lat_second);
    pc.printf(" lon:\t\t%d度%d分%.4f秒\r\n", lon_degree, lon_minute, lon_second);
    pc.printf("\r\n");
    
    pc.printf(" internal:\tvoltage\t\tcurrent\r\n");
    pc.printf("          \t%.2f[V]\t\t%.0f[mA]\r\n", voltage_in / 1000.0f, current_in);
    pc.printf(" external:\tvoltage\t\tcurrent\r\n");
    pc.printf("          \t%.2f[V]\t\t%.0f[mA]\r\n", voltage_ex / 1000.0f, current_ex);
    pc.printf("\r\n");
    pc.printf(" press:\t\t%.2f[hPa]\r\n", press);
    pc.printf(" temp:\t\t%.2f[C]\r\n", temp);
    pc.printf("\r\n");
    pc.printf(" high_accel:\tx\t\ty\t\tz\r\n");
    pc.printf("       \t\t%.2f\t\t%.2f\t\t%.2f\t[G]\r\n", high_accel[0], high_accel[1], high_accel[2]);
    pc.printf(" accel:\t\tx\t\ty\t\tz\r\n");
    pc.printf("       \t\t%.2f\t\t%.2f\t\t%.2f\t[G]\r\n", accel[0], accel[1], accel[2]);
    pc.printf(" gyro:\t\tx\t\ty\t\tz\r\n");
    pc.printf("       \t\t%.2f\t\t%.2f\t\t%.2f\t[rad/s]\r\n", gyro[0], gyro[1], gyro[2]);
}