#include "mbed.h"
#include "EEPROM_24FC1025.h"

Serial pc(USBTX, USBRX, 230400);

I2C i2cBus(p9, p10);
#define A0_CONNECT 0
#define A1_CONNECT 0
EEPROM_24FC1025 eeprom0(i2cBus, A0_CONNECT, A1_CONNECT);

/**
*   EEPROMは書き込み回数に限りがあるので，むやみに書き込まないように！！
*/
int main() {
    for(int i = 0; i < 16; i++){
        eeprom0.write((uint64_t)i, 0x07);   
        wait_ms(10);
    }
    pc.printf("0\t00 01 02 03 04 05 06 07\r\n");
    for(uint64_t i = 0 ; i < 131073; i += 8){
        uint8_t data[8] = {0};
        eeprom0.read(i, data, 8);
        pc.printf("%d\t", i);
        for(int j = 0; j < 8; j++){
            pc.printf("%02X ",data[j]);
        }
        pc.printf("\r\n");
    }
}