#include "mbed.h"
#include "ES920LR.hpp"

#define TX D1
#define RX D0

RawSerial pc(USBTX,USBRX,115200);
RawSerial bus(TX, RX, 115200);
ES920LR es(bus, pc, 115200);

bool safety_flag = false;

Timeout send;

//safety device release command
//forced transition fllight mode
//forced nicrom fire

void header0x10()
{
    char buff = pc.getc();
    
    if(buff == 'R')es << (char)0x10 << 'r' << es.endl;          //release's  "r"
    else if(buff == 'F') es << (char)0x10 << 'f' << es.endl;    //flight's   "f"
    else if(buff == 'N') es << (char)0x10 << 'n' << es.endl;    //nicrom's   "n"
    else if(buff == 'S') es << (char)0x10 << 's' << es.endl;    //solenoid's "s"
    else if(buff == 'C') es << (char)0x10 << 'c' << es.endl;    //collect's  "c"
    else if(buff == 'D') es << (char)0x10 << 'd' << es.endl;    //debug's    "d"
    else if(buff == 'I') es << (char)0x10 << 'i' << es.endl;    //inner's    "i"
    else if(buff == 'B') es << (char)0x10 << 'b' << es.endl;    //beck's     "b"
    else pc.printf("NG command\r\n");
}




bool bit_check(short data, short mask)
{
    if((data & mask) == mask)return true;
    else return false;
}
/*
if(safety_flag)             state |= 0x01;  //0bit
if(flight_detect_mode)      state |= 0x02;  //1bit
if(hr.flight_pin_state)     state |= 0x04;  //2bit
if(flight_mode)             state |= 0x08;  //3bit
if(sepa_accept)             state |= 0x10;  //4bit
if(extrusion_accept)        state |= 0x20;  //5bit
if(collect_mode)            state |= 0x40;  //6bit
if(vertex_arrival)          state |= 0x80;  //7bit
*/
void flag_display(char data)
{
    
    if(data & 0x80)pc.printf("1");
    else pc.printf("0");
    
    if(data & 0x40)pc.printf("1");
    else pc.printf("0");
    
    if(data & 0x20)pc.printf("1");
    else pc.printf("0");
    
    if(data & 0x10)pc.printf("1|");
    else pc.printf("0|");
    
    if(data & 0x08)pc.printf("1");
    else pc.printf("0");
    
    if(data & 0x04)pc.printf("1");
    else pc.printf("0");
    
    if(data & 0x02)pc.printf("1");
    else pc.printf("0");

    
    if(data & 0x01)pc.printf("1\r\n");
    else pc.printf("0\r\n");
    
    if(data==0x00)pc.printf("安全装置：ロック\r\n");
    if(data==0x01)pc.printf("安全装置：解除\r\n");
    if(data==0x03)pc.printf("フライトピン待機状態\r\n");
    if(data==0x07)pc.printf("フライトピンが抜けた\r\n");
    if(data==0x0F)pc.printf("飛行中\r\n");
    if(data==0x1F || data==0x9F)pc.printf("ニクロムファイア\r\n");
    if(data==0x3F || data==0xBF)pc.printf("ソレノイドプッシュ\r\n");
    if(data==0x7F || data==0xFF)pc.printf("回収モード\r\n");
    
}

void second_to_time(int data)
{
    char hour,min,second;
    float dummy;
    
    dummy = (float)(data/3600);
    hour = (char)dummy;
    data -= 3600*(int)hour;
    
    dummy = (float)(data/60);
    min = (char)dummy;
    data -= 60*(int)min;
    
    second = (char)data;
    
    pc.printf("Inner Time = %d hour %d min %d sec\r\n", hour, min, second);
}


void header0x01()
{
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    
    if(es.data[0] == (char)9) //PQの9
    {
        pc.printf("safety device release complete\r\n");
        safety_flag = true;
    }
    else
    {
        pc.printf("couldn't communicate\r\n");
        safety_flag = false;
    } 
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
}   

// センサ  external_INA inner_INA mpu_acc mpu_mag LPS22HB SHT35 TSL2561 three SD
// ビット             8         7       6       5       4     3       2     1  0
// 対応するビットがHIGHになっておれば接続確認できている 
void header0x02()
{
    short state = es.toShort(0);
    if(state & 0x001)pc.printf("external ina OK\r\n");
    else pc.printf("external ina NG\r\n");
    
    if(state & 0x002)pc.printf("inner ina OK\r\n");
    else pc.printf("inner ina NG\r\n");
    
    if(state & 0x004)pc.printf("mpu acc OK\r\n");
    else pc.printf("mpu acc OK\r\n");
    
    if(state & 0x008)pc.printf("mpu mag OK\r\n");
    else pc.printf("mpu mag OK\r\n");
    
    if(state & 0x010)pc.printf("LPS22HB OK\r\n");
    else pc.printf("LPS22HB NG\r\n");
    
    if(state & 0x020)pc.printf("SHT35 OK\r\n");
    else pc.printf("SHT35 NG\r\n");
    
    if(state & 0x040)pc.printf("TSL2561 OK\r\n");
    else pc.printf("TSL2561 NG\r\n");
    
    if(state & 0x080)pc.printf("ADXL OK\r\n");
    else pc.printf("ADXL NG\r\n");
    
    if(state & 0x100)pc.printf("SD OK\r\n");
    else pc.printf("SD NG\r\n");
    
    if(state & 0x200)pc.printf("GPS OK\r\n");
    else pc.printf("GPS NO\r\n");
}

#define COMPRES_Inner_Time  36.40833333     //32768/1800
#define COMPRES_Q           305200          // ? pakuru
#define COMPRES_VOLTAGE     0.9102222       // 65535/36 = 
#define COMPRES_CURRENT     0.8192          // 65535/40 = 
#define COMPRES_PRESSURE    26.0063         // 65535/1260 =  
#define COMPRES_ALTITUDE    65.536          // 65535/500 =  //range = 0~500
#define COMPRES_VELOCITY    327.68          // 65535/100 =  //pakuru
#define COMPRES_LUMINOSITY  3.2768          // 65535/10000 = 
#define COMPRES_TEMPERATURE 546.133         // 63353/60 =   //range = -20 ~ 40 
#define COMPRES_HUMIDITY    327.68          // 65535/100 = 
#define COMPRES_ACC         81.92           // 65535/400 = 
#define COMPRES_PITOT       32768           // 65535/1 = 

void header0x03()
{
    int i=0;
    
    pc.printf("header:0x03\r\n");
    
    if(es.data[i]==1 || es.data[i]==2 || es.data[i]==3)
    {
        
        pc.printf("rocket phase : %d\r\n",es.data[i]);          
        i++;
        
        flag_display(es.data[i]);
        i++;
        
        second_to_time(es.toInt(i));
        i+=4;
        
        //i+=8;
        
        pc.printf("latitude = %f\r\n",es.toFloat(i));
        i+=4;
        
        pc.printf("longitude = %f\r\n",es.toFloat(i));
        i+=4;
        
        /*
        pc.printf("ex_vol = %f\r\n",es.toFloat(i));
        i+=4;
        
        pc.printf("ex_current = %f\r\n",es.toFloat(i));
        i+=4;
        
        pc.printf("in_vol = %f\r\n",es.toFloat(i));
        i+=4;
        
        pc.printf("in_current = %f\r\n",es.toFloat(i));
        i+=4;
        
        //pc.printf("pressure = %f\r\n",es.toFloat(i));
        //i+=4;
        
        //pc.printf("lux = %f\r\n",es.toFloat(i));
        //i+=4;
        
        
        pc.printf("press = %f\r\n",(float)(es.toShort(i) / COMPRES_PRESSURE));
        i+=2;
        
        pc.printf("lux  %f\r\n", (float)(es.toShort(i) / COMPRES_LUMINOSITY));
        i+=2;
        
        pc.printf("temp = %f\r\n",(float)(es.toShort(i) / COMPRES_TEMPERATURE));
        i+=2;
        
        pc.printf("hum = %f\r\n",(float)(es.toShort(i) / COMPRES_HUMIDITY));
        i+=2;
        */
        pc.printf("ex_vol = %f\r\n",(float)(es.toShort(i))/COMPRES_VOLTAGE);     
        i+=2;
        
        pc.printf("ex_current = %f\r\n",(float)(es.toShort(i))/COMPRES_CURRENT); 
        i+=2;
        
        //pc.printf("i = %d\r\n",i);
        pc.printf("in_vol = %f\r\n",(float)(es.toShort(i))/COMPRES_VOLTAGE);     
        i+=2;

        pc.printf("in_current = %f\r\n",(float)(es.toShort(i))/COMPRES_CURRENT); 
        i+=2;
        
        pc.printf("pressure = %f\r\n",(float)(es.toShort(i)/COMPRES_PRESSURE));
        i+=2;
        
        pc.printf("luminosity = %f\r\n",(float)(es.toShort(i)/COMPRES_LUMINOSITY));
        i+=2;
        
        pc.printf("temperature = %f\r\n",(float)(es.toShort(i))/COMPRES_TEMPERATURE);
        i+=2;
        
        pc.printf("humidity = %f\r\n",(float)(es.toShort(i))/COMPRES_HUMIDITY);
        i+=2;
        
        
    }
    if(es.data[i]==4)
    {
        pc.printf("rocket phase : %d\r\n",es.data[i]);          
        i++;
        
        flag_display(es.data[i]);
        i++;
        
        second_to_time(es.toInt(i));
        i+=4;
        
        pc.printf("latitude = %f\r\n",es.toFloat(i));
        i+=4;
        
        pc.printf("longitude = %f\r\n",es.toFloat(i));
        i+=4;
        
        /*
        pc.printf("i = %d\t",i);
        pc.printf("Q.w = %f\r\n",(float)(es.toShort(i))*COMPRES_Q);       
        i+=2;
        
        pc.printf("i = %d\t",i);
        pc.printf("Q.x = %f\r\n",(float)(es.toShort(i))*COMPRES_Q);       
        i+=2;
        
        pc.printf("i = %d\t",i);
        pc.printf("Q.y = %f\r\n",(float)(es.toShort(i))*COMPRES_Q);       
        i+=2;
        
        pc.printf("i = %d\t",i);
        pc.printf("Q.z = %f\r\n",(float)(es.toShort(i))*COMPRES_Q);       
        i+=2;
        */
        //i+=8;

        pc.printf("in_vol = %f\r\n",(float)(es.toShort(i))/COMPRES_VOLTAGE);     
        i+=2;

        pc.printf("in_current = %f\r\n",(float)(es.toShort(i))/COMPRES_CURRENT); 
        i+=2;

        pc.printf("altitude = %f\r\n",es.toFloat(i));  
        i+=4;

        pc.printf("velocity = %f\r\n",es.toFloat(i));
        i+=4;

        pc.printf("luminosity = %f\r\n",(float)(es.toShort(i))/COMPRES_LUMINOSITY); 
        i+=2;

        pc.printf("temperature = %f\r\n",(float)(es.toShort(i))/COMPRES_TEMPERATURE);
        i+=2;

        pc.printf("humidity = %f\r\n",(float)(es.toShort(i))/COMPRES_HUMIDITY);
        i+=2;
    
        pc.printf("press_pitot = %f\r\n",(float)(es.toShort(i))/COMPRES_PITOT);
        i+=2;
        
        pc.printf("gps_altitude = %f\r\n",(float)(es.toShort(i)/COMPRES_ALTITUDE));
        i+=2;
    }
    if(es.data[i]==5)
    {
        pc.printf("rocket phase : %d\r\n",es.data[i]);          
        i++;
        
        flag_display(es.data[i]);
        /*
        pc.printf("i = %d\t",i);
        pc.printf("rocket state : 0x%x\r\n",es.data[i]);          
        */
        i++;

        second_to_time(es.toInt(i));
        i+=4;
        /*
        pc.printf("i = %d\t",i);
        pc.printf("Inner time = %d\r\n",es.toInt(i));
        i+=4;
        */
        
        //pc.printf("i = %d\t",i);
        pc.printf("longitude = %f\r\n",es.toFloat(i));
        i+=4;
        
        //pc.printf("i = %d\t",i);
        pc.printf("latitude = %f\r\n",es.toFloat(i));
        i+=4;
        
        //i+=8;
        
        pc.printf("in_vol = %f\r\n",(float)(es.toShort(i))/COMPRES_VOLTAGE);     
        i+=2;

        pc.printf("in_current = %f\r\n",(float)(es.toShort(i))/COMPRES_CURRENT); 
        i+=2;
        
        pc.printf("press = %f\r\n",(float)(es.toShort(i) / COMPRES_PRESSURE));
        i+=2;

        pc.printf("luminosity = %f\r\n",(float)(es.toShort(i)/COMPRES_LUMINOSITY));
        i+=2;

        pc.printf("temperature = %f\r\n",(float)(es.toShort(i)/COMPRES_TEMPERATURE));
        i+=2;

        pc.printf("humidity = %f\r\n",(float)(es.toShort(i)/COMPRES_HUMIDITY));
        i+=2;
    }
}

void header0x05()
{
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("header:0x05\r\n");
    
    if(es.data[0] == 'd')pc.printf("flight pin detect\r\n");
    //else pc.printf("NG data\r\n");
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    
}

void header0x06()
{
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("header:0x06\r\n");
    
    if(es.data[0] == 'n')pc.printf("nicrom fire finish\r\n");
    //else pc.printf("NG data\r\n");
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
}

void header0x07()
{
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("header:0x07\r\n");
    
    if(es.data[0] == 's')pc.printf("solenoid push complete\r\n");
    //else pc.printf("NG data\r\n");
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
}

void header0x08()
{
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    //pc.printf("header:0x08\r\n");
    
    if(es.data[0] == 'c')pc.printf("collect mode transimit complete\r\n");
    else pc.printf("NG data\r\n");
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
}

void header0x09()
{
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("header:0x09\r\n");
    
    if(es.data[0] == 1)pc.printf("ROCKET PHASE 1 START\r\n");
    if(es.data[0] == 2)pc.printf("ROCKET PHASE 2 START\r\n");
    if(es.data[0] == 3)pc.printf("ROCKET PHASE 3 START\r\n");
    if(es.data[0] == 4)pc.printf("ROCKET PHASE 4 START\r\n");
    if(es.data[0] == 5)pc.printf("ROCKET PHASE 5 START\r\n");    
    //else pc.printf("NG data\r\n");

    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
}

void header0x1A()
{
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("header : 0x1A\r\n");
    
    if(es.data[0] == 'd'){pc.printf("Rocket's transceiver normal\r\n");}
    if(es.data[0] == 'i'){pc.printf("Inner time reset complete\r\n");}
    if(es.data[0] == 'b'){pc.printf("safety device reboot complete\r\n");}
    //else pc.printf("NG command\r\n");
    
    pc.printf("--------------------------------------------------------\r\n");
    pc.printf("--------------------------------------------------------\r\n");
}


int main() {
    
    pc.attach(&header0x10, Serial::RxIrq);
    
    es.attach(&header0x01, (char)0x01);
    es.attach(&header0x02, (char)0x02);
    es.attach(&header0x03, (char)0x03);
    //es.attach(&header0x04, (char)0x04);
    es.attach(&header0x05, (char)0x05);
    es.attach(&header0x06, (char)0x06);
    es.attach(&header0x07, (char)0x07);
    es.attach(&header0x08, (char)0x08);
    es.attach(&header0x09, (char)0x09);
    
    es.attach(&header0x1A, (char)0x1A);
    

    
    while(1)
    {
        pc.printf("couldn't receive cmd\r\n");
        
        wait(30);
    }
    
    
}
