#include"mbed.h"
#include"HDC1050.h"

//Serial pc(USBTX, USBRX); //tx, rx

myHDC1050 :: myHDC1050(I2C &i2cBus){
    i2c = &i2cBus;
    i2c->frequency(400000);
}
/**************
温度、湿度を同時にとるか、個別にとるかを選択
同時に取得             i=0
個別に取得             i=1
同時に取得(ヒーター付き) i=2
****************/
void myHDC1050::setup(int i)
{
    reg = check_reg;
    char cmd[3][2];
    cmd[0][0] = 0x10; cmd[0][1] = 0x00;
    cmd[1][0] = 0x00; cmd[1][1] = 0x00;
    cmd[2][0] = 0x03; cmd[2][1] = 0x00;
    
    i2c->write(SLV_WRITE, &reg, 1, true);
    i2c->write(SLV_WRITE, cmd[i], 2, false);
}

/******************
HDC1050との接続確認
0が返ってくればOK
1が返ってくればError
*******************/
    
int myHDC1050::Connection_check()
{
    char reg = check_reg;
    char check[2];
    
    i2c->write(SLV_WRITE,&reg,1);
    i2c->read(SLV_READ,check,2);
    
    if(check[0] == 0x10 && check[1] == 0x50)return 0;
    else return 1;

}    
/*************
温度、湿度を取得

@example

  float temp,hum;

  myHDC1050.setup(0); or myHDC1050.setup(2);
  myHDC1050.get_temp_hum(&temp,&hum);
**************/
void myHDC1050::get_temp_hum(float *temp, float *hum)
{
    char reg = Temperature_reg;
    char buff[4];
    unsigned int val[4];
    
    //setup(0);
    
    i2c->write(SLV_WRITE, &reg,1);
    wait_ms(250);
    i2c->read(SLV_READ, buff,4,false);
    
    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    val[2] = (unsigned int)buff[2] << 8;
    val[3] = (unsigned int)buff[3];
    
    *temp = (float)(val[0] | val[1]);
    *hum  = (float)(val[2] | val[3]);
    
    *temp = *temp*165.0/65536.0 - 40.0;
    *hum = *hum*100.0/65536.0;

}
/*************
温度を取得

@example

  float temp;

  myHDC1050.setup(1);
  temp = myHDC1050.get_temp();
**************/
float myHDC1050::get_temp()
{
    char reg = Temperature_reg;
    char buff[2];
    unsigned int val[2];     
    float temp;
    
    //setup(1);
       
    i2c->write(SLV_WRITE, &reg,1);
    wait_ms(130);
    i2c->read(SLV_READ, buff, 2,false);
    
    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    
    temp = (float)(val[0] | val[1]);
    temp = temp *165.0/65536.0 - 40.0;
    
    return temp;
    
}
/*************
湿度を取得

@example

  float hum;

  myHDC1050.setup(1);
  hum = myHDC1050.get_hum();
**************/
float myHDC1050::get_hum()
{
    char reg = Humidity_reg;
    char buff[2];
    unsigned int val[2];
    float hum;
    
    setup(1);
     
    i2c->write(SLV_WRITE, &reg,1);
    wait_ms(130);
    i2c->read(SLV_READ, buff, 2,false);
    
    val[0] = (unsigned int)buff[0] << 8;
    val[1] = (unsigned int)buff[1];
    
    hum = (float)(val[0] | val[1]);
    hum = hum*100.0/65536.0;
    
    return hum;

}