#include "mbed.h"
#include "EEPROM_lib.h"

EEPROM_lib::EEPROM_lib(I2C &user_i2c, int num){
    i2c = &user_i2c;
    i2c -> frequency(400000);
    
    max_num = num;
    buff_ptr = 0;
    ptr[3] = ptr[2] = ptr[1] = ptr[0] = 0x00;
}

void EEPROM_lib::writeByte(int num, int block, char ADDR_H, char ADDR_L, char DATA){
    if(num > max_num){
        return;
    }
    switch(num){
        case 1:
        slave = EEPROM_ADDR_00_0;
        break;
        
        case 2:
        slave = EEPROM_ADDR_01_0;
        break;
        
        case 3:
        slave = EEPROM_ADDR_10_0;
        break;
        
        case 4:
        slave = EEPROM_ADDR_11_0;
        break;
    }
    if(block == 1){
        slave = slave | 0x08;
    }
    cmd[0] = ADDR_H;
    cmd[1] = ADDR_L;
    cmd[2] = DATA;
    
    i2c -> write(slave, cmd, 3);
    wait_us(EEPROM_WAIT_US);
}

void EEPROM_lib::writePage(int num, int block, char ADDR_H, char ADDR_L, char *DATA){
    if(num > max_num){
        return;
    }
    switch(num){
        case 1:
        slave = EEPROM_ADDR_00_0;
        break;
        
        case 2:
        slave = EEPROM_ADDR_01_0;
        break;
        
        case 3:
        slave = EEPROM_ADDR_10_0;
        break;
        
        case 4:
        slave = EEPROM_ADDR_11_0;
        break;
    }
    if(block == 1){
        slave = slave | 0x08;
    }
    cmd[0] = ADDR_H;
    cmd[1] = ADDR_L;
    for(int i = 2; i < 130; i ++){
        cmd[i] = DATA[i-2];
    }
    
    i2c -> write(slave, cmd, 130);
    wait_us(EEPROM_WAIT_US);
}

void EEPROM_lib::setWriteAddr(int num, int block, char ADDR_H, char ADDR_L){
    if(num > max_num){
        return;
    }
    switch(num){
        case 1:
        slave = EEPROM_ADDR_00_0;
        break;
        
        case 2:
        slave = EEPROM_ADDR_01_0;
        break;
        
        case 3:
        slave = EEPROM_ADDR_10_0;
        break;
        
        case 4:
        slave = EEPROM_ADDR_11_0;
        break;
    }
    if(block == 1){
        slave = slave | 0x08;
    }
    cmd[0] = ADDR_H;
    cmd[1] = ADDR_L;
    
    ptr[0] = (char)num - 1;
    ptr[1] = (char)block;
    ptr[2] = ADDR_H;
    ptr[3] = ADDR_L;
}

int EEPROM_lib::chargeBuff(char DATA){
    if(buff_ptr < 128){
        EEPROM_cast.c = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        
        buff_ptr ++;
    }
    return buff_ptr;
}

int EEPROM_lib::chargeBuff(bool DATA){
    if(buff_ptr < 128){
        EEPROM_cast.b = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        
        buff_ptr ++;
    }
    return buff_ptr;
}

int EEPROM_lib::chargeBuff(int DATA){
    if(buff_ptr < 128 - 3){
        EEPROM_cast.i = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        cmd[buff_ptr + 3] = EEPROM_cast.cast[1];
        cmd[buff_ptr + 4] = EEPROM_cast.cast[2];
        cmd[buff_ptr + 5] = EEPROM_cast.cast[3];
        
        buff_ptr += 4;
    }
    return buff_ptr;
}

int EEPROM_lib::chargeBuff(short DATA){
    if(buff_ptr < 128 - 1){
        EEPROM_cast.s = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        cmd[buff_ptr + 3] = EEPROM_cast.cast[1];
        
        buff_ptr += 2;
    }
    return buff_ptr;
}

int EEPROM_lib::chargeBuff(long long DATA){
    if(buff_ptr < 128 - 7){
        EEPROM_cast.ll = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        cmd[buff_ptr + 3] = EEPROM_cast.cast[1];
        cmd[buff_ptr + 4] = EEPROM_cast.cast[2];
        cmd[buff_ptr + 5] = EEPROM_cast.cast[3];
        cmd[buff_ptr + 6] = EEPROM_cast.cast[4];
        cmd[buff_ptr + 7] = EEPROM_cast.cast[5];
        cmd[buff_ptr + 8] = EEPROM_cast.cast[6];
        cmd[buff_ptr + 9] = EEPROM_cast.cast[7];
        
        buff_ptr += 8;
    }
    return buff_ptr;
}

int EEPROM_lib::chargeBuff(float DATA){
    if(buff_ptr < 128 - 3){
        EEPROM_cast.f = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        cmd[buff_ptr + 3] = EEPROM_cast.cast[1];
        cmd[buff_ptr + 4] = EEPROM_cast.cast[2];
        cmd[buff_ptr + 5] = EEPROM_cast.cast[3];
        
        buff_ptr += 4;
    }
    return buff_ptr;
}

int EEPROM_lib::chargeBuff(double DATA){
    if(buff_ptr < 128 - 7){
        EEPROM_cast.d = DATA;
        cmd[buff_ptr + 2] = EEPROM_cast.cast[0];
        cmd[buff_ptr + 3] = EEPROM_cast.cast[1];
        cmd[buff_ptr + 4] = EEPROM_cast.cast[2];
        cmd[buff_ptr + 5] = EEPROM_cast.cast[3];
        cmd[buff_ptr + 6] = EEPROM_cast.cast[4];
        cmd[buff_ptr + 7] = EEPROM_cast.cast[5];
        cmd[buff_ptr + 8] = EEPROM_cast.cast[6];
        cmd[buff_ptr + 9] = EEPROM_cast.cast[7];
        
        buff_ptr += 8;
    }
    return buff_ptr;
}

void EEPROM_lib::writeBuff(){
    for(int i = buff_ptr+2; i < 130; i ++){
        cmd[i] = 0x00;
    }
    i2c -> write(slave, cmd, 130);
    wait_us(EEPROM_WAIT_US);
    
    buff_ptr = 0;
}

int EEPROM_lib::setNextPage(){
    if(cmd[1] == 0x00){
        cmd[1] = 0x80;
        ptr[3] = cmd[1];
    }
    else{
        cmd[1] = 0x00;
        ptr[3] = cmd[1];
        if(cmd[0] == 0xFF){
            cmd[0] = 0x00;
            ptr[2] = cmd[0];
            switch(slave){
                case EEPROM_ADDR_00_0:
                slave = EEPROM_ADDR_00_1;
                ptr[0] = 0x00;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_00_1:
                slave = EEPROM_ADDR_01_0;
                ptr[0] = 0x01;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_01_0:
                slave = EEPROM_ADDR_01_1;
                ptr[0] = 0x01;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_01_1:
                slave = EEPROM_ADDR_10_0;
                ptr[0] = 0x02;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_10_0:
                slave = EEPROM_ADDR_10_1;
                ptr[0] = 0x02;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_10_1:
                slave = EEPROM_ADDR_11_0;
                ptr[0] = 0x03;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_11_0:
                slave = EEPROM_ADDR_11_1;
                ptr[0] = 0x03;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_11_1:
                slave = 0x00;
                ptr[0] = 0x04;
                ptr[1] = 0x00;
            }
        }
        else{
            cmd[0] ++;
            ptr[2] = cmd[0];
            switch(slave){
                case EEPROM_ADDR_00_0:
                ptr[0] = 0x00;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_00_1:
                ptr[0] = 0x00;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_01_0:
                ptr[0] = 0x01;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_01_1:
                ptr[0] = 0x01;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_10_0:
                ptr[0] = 0x02;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_10_1:
                ptr[0] = 0x02;
                ptr[1] = 0x01;
                break;
                
                case EEPROM_ADDR_11_0:
                ptr[0] = 0x03;
                ptr[1] = 0x00;
                break;
                
                case EEPROM_ADDR_11_1:
                ptr[0] = 0x03;
                ptr[1] = 0x01;
                break;
            }
        }
    }
    
    switch(max_num){
        case 1:
        if(ptr[0] > 0x00){
            slave = 0x00;
            cmd[0] = 0x00;
            cmd[1] = 0x00;
            ptr[0] = 0x01;
            ptr[1] = 0x00;
            ptr[2] = 0x00;
            ptr[3] = 0x00;
        }
        break;
        
        case 2:
        if(ptr[0] > 0x01){
            slave = 0x00;
            cmd[0] = 0x00;
            cmd[1] = 0x00;
            ptr[0] = 0x02;
            ptr[1] = 0x00;
            ptr[2] = 0x00;
            ptr[3] = 0x00;
        }
        break;
        
        case 3:
        if(ptr[0] > 0x02){
            slave = 0x00;
            cmd[0] = 0x00;
            cmd[1] = 0x00;
            ptr[0] = 0x03;
            ptr[1] = 0x00;
            ptr[2] = 0x00;
            ptr[3] = 0x00;
        }
        break;
        
        case 4:
        if(ptr[0] > 0x03){
            slave = 0x00;
            cmd[0] = 0x00;
            cmd[1] = 0x00;
            ptr[0] = 0x04;
            ptr[1] = 0x00;
            ptr[2] = 0x00;
            ptr[3] = 0x00;
        }
        break;
    }
    
    return (ptr[0] << 24) | (ptr[1] << 16) | (ptr[2] << 8) | ptr[3];
}

char EEPROM_lib::readByte(int num, int block, char ADDR_H, char ADDR_L){
    if(num > max_num){
        return 0x00;
    }
    switch(num){
        case 1:
        slave = EEPROM_ADDR_00_0;
        break;
        
        case 2:
        slave = EEPROM_ADDR_01_0;
        break;
        
        case 3:
        slave = EEPROM_ADDR_10_0;
        break;
        
        case 4:
        slave = EEPROM_ADDR_11_0;
        break;
    }
    if(block == 1){
        slave = slave | 0x08;
    }
    cmd[0] = ADDR_H;
    cmd[1] = ADDR_L;
    
    i2c -> write(slave, cmd, 2);
    i2c -> read(slave | 1, cmd, 1);
    
    return cmd[0];
}

void EEPROM_lib::readMultiByte(int num, int block, char ADDR_H, char ADDR_L, char *DATA, int size){
    if(num > max_num){
        return;
    }
    switch(num){
        case 1:
        slave = EEPROM_ADDR_00_0;
        break;
        
        case 2:
        slave = EEPROM_ADDR_01_0;
        break;
        
        case 3:
        slave = EEPROM_ADDR_10_0;
        break;
        
        case 4:
        slave = EEPROM_ADDR_11_0;
        break;
    }
    if(block == 1){
        slave = slave | 0x08;
    }
    cmd[0] = ADDR_H;
    cmd[1] = ADDR_L;
    
    i2c -> write(slave, cmd, 2);
    i2c -> read(slave | 1, DATA, size);
}
