#include "mbed.h"
#include "EEPROM_lib.h"

Serial pc(USBTX, USBRX, 115200);
I2C i2c_bus(p28, p27);

EEPROM_lib EEPROM(i2c_bus, 4);

int main() {
    wait(1.0f);
    
    pc.printf("\r\n");
    pc.printf("EEPROM Reset Program\r\n");
    pc.printf("Please Input 'E' (large E) to Start : ");
    while(1){
        if(pc.getc() == 'E'){
            pc.printf("START\r\n\n");
            break;
        }
    }
    
    pc.printf("EEPROM Reset...");
    EEPROM.setWriteAddr(1, 0, 0x00, 0x00);
    int ptr;
    while(1){
        while(1){
            ptr = EEPROM.chargeBuff((char)0xFF);
            if(ptr == 128){
                EEPROM.writeBuff();
                ptr = EEPROM.setNextPage();
                //pc.printf("Page : %08x\r\n", ptr);
                pc.printf(".");
                break;
            }
        }
        if(ptr >= 0x04000000){ 
            break;
        }
    }
    pc.printf("Complete!!\r\n");
    
    
    pc.printf("Checking...");
    wait(0.5f);
    
    char ADDR_H, ADDR_L;
    int num, block;
    char data[128];
    int error_count = 0;
    
    ADDR_H = ADDR_L = 0x00;
    num = 1;
    block = 0;
    
    for(int i = 0; i < 4096; i ++){
        switch(i){
            case 512:
            num = 1;
            block = 1;
            break;
            
            case 1024:
            num = 2;
            block = 0;
            break;
            
            case 1536:
            num = 2;
            block = 1;
            break;
            
            case 2048:
            num = 3;
            block = 0;
            break;
            
            case 2560:
            num = 3;
            block = 1;
            break;
            
            case 3072:
            num = 4;
            block = 0;
            break;
            
            case 3584:
            num = 4;
            block = 1;
            break;
        }
        
        EEPROM.readMultiByte(num, block, ADDR_H, ADDR_L, data, 128);
        //pc.printf("%d %01d %02x %02x\r\n", num, block, ADDR_H, ADDR_L);
        pc.printf(".");
        for(int x = 0; x < 128; x ++){
            if(data[x] != 0xFF){
                pc.printf("Error at %1d %01d %02x %02x\r\n", num, block, ADDR_H, ADDR_L+x);
                error_count ++;
            }
        }
        
        if(ADDR_L == 0x00){
            ADDR_L = 0x80;
        }
        else{
            ADDR_L = 0x00;
            ADDR_H ++;
        }
    }
    
    if(error_count != 0){
        pc.printf("System find Error.\r\nPlease Check Connection and Settings.\r\n");
    }
    else{
        pc.printf("Complete!!\r\nConnected EEPROM Are All Reseted.\r\n");
    }
    
    while(1) {
    }
}
