#include "mbed.h"
#include "SDFileSystem.h"
#include "EEPROM_lib.h"

Serial pc(USBTX, USBRX, 115200);
I2C i2c_bus(p28, p27);

EEPROM_lib EEPROM(i2c_bus, 4);
SDFileSystem sd(p5, p6, p7, p8, "sd");

const int DATA_INT = 1, DATA_FLOAT = 2, DATA_DOUBLE = 3, DATA_BOOL = 4, DATA_CHAR = 5, DATA_SHORT = 6, DATA_LONGLONG = 7;

FILE *file_bin, *file_format, *file_out;

int main() {
    wait(1.0f);
    
    //プログラムの説明
    pc.printf("\r\n");
    pc.printf("EEPROM's Binary Data Encode for Text Data\r\n");
    pc.printf("Please Input 'D' (large D) to Start : ");
    while(1){
        if(pc.getc() == 'D'){
            pc.printf("START\r\n\n");
            break;
        }
    }
    
    //フォーマットファイルの探索
    printf("Searching file [format.txt] in SD...\r\n");
    file_format = fopen("/sd/format.txt", "r");
    if(file_format == NULL){
        pc.printf("[format.txt] not found.\r\n");
        pc.printf("Please Add file [format.txt] in SD\r\n");
        while(1);
    }
    else{
        pc.printf("[format.txt] OK!!\r\n");
    }
    
    
    //フォーマットファイルの読み取り
    char data_line[16], data_format[16];
    int format_length[128], format_length_n = 0;
    
    pc.printf("Read [format.txt].\r\n");
    while(fgets(data_line, 16, file_format) != NULL){
        sscanf(data_line, "%s", data_format);
        if(strcmp(data_format, "int") == 0){
            format_length[format_length_n++] = DATA_INT;
            pc.printf("%d : int\r\n", format_length_n - 1);
        }
        else if(strcmp(data_format, "float") == 0){
            format_length[format_length_n++] = DATA_FLOAT;
            pc.printf("%d : float\r\n", format_length_n - 1);
        }
        else if(strcmp(data_format, "double") == 0){
            format_length[format_length_n++] = DATA_DOUBLE;
            pc.printf("%d : double\r\n", format_length_n - 1);
        }
        else if(strcmp(data_format, "bool") == 0){
            format_length[format_length_n++] = DATA_BOOL;
            pc.printf("%d : bool\r\n", format_length_n - 1);
        }
        else if(strcmp(data_format, "short") == 0){
            format_length[format_length_n++] = DATA_SHORT;
            pc.printf("%d : short\r\n", format_length_n - 1);
        }
        else if(strcmp(data_format, "longlong") == 0){
            format_length[format_length_n++] = DATA_LONGLONG;
            pc.printf("%d : long long\r\n", format_length_n - 1);
        }
        else{
            pc.printf("ERROR : format error!!!!!\r\n");
        }
    }
    
    fclose(file_format);
    pc.printf("OK!!\r\n");
    
    
    //EEPROMの中身をSDに移植
    char ADDR_H, ADDR_L;
    int num, block;
    char data_eeprom[128];
    
    ADDR_H = ADDR_L = 0x00;
    num = 1;
    block = 0;
    
    file_bin = fopen("/sd/EEPROM_data.bin", "wb");
    
    pc.printf("Data Copy [EEPROM -> SD].");
    
    for(int i = 0; i < 4096; i ++){
        switch(i){
            case 512:
            num = 1;
            block = 1;
            break;
            
            case 1024:
            num = 2;
            block = 0;
            break;
            
            case 1536:
            num = 2;
            block = 1;
            break;
            
            case 2048:
            num = 3;
            block = 0;
            break;
            
            case 2560:
            num = 3;
            block = 1;
            break;
            
            case 3072:
            num = 4;
            block = 0;
            break;
            
            case 3584:
            num = 4;
            block = 1;
            break;
        }
        
        EEPROM.readMultiByte(num, block, ADDR_H, ADDR_L, data_eeprom, 128);
        //pc.printf("%d %01d %02x %02x\r\n", num, block, ADDR_H, ADDR_L);
        pc.printf(".");
        fwrite(data_eeprom, sizeof(char), 128, file_bin);
        
        if(ADDR_L == 0x00){
            ADDR_L = 0x80;
        }
        else{
            ADDR_L = 0x00;
            ADDR_H ++;
        }
    }
    
    fclose(file_bin);
    pc.printf("OK!!\r\n");
    
    
    //バイナリファイルのオープン（読み取り用に）
    pc.printf("Binary File Open : ");
    file_bin = fopen("/sd/EEPROM_data.bin", "rb");
    if(file_bin == NULL){
        pc.printf("NG...\r\n");
        pc.printf("Please Check Connection and Settings\r\n");
        while(1);
    }
    else{
        pc.printf("OK!!\r\n");
    }
    
    
    //書き込むファイルのオープン
    pc.printf("Text File Open : ");
    file_out = fopen("/sd/EEPROM_encode_data.txt", "w");
    if(file_out == NULL){
        pc.printf("NG...\r\n");
        pc.printf("Please Check Connection and Settings\r\n");
        while(1);
    }
    else{
        pc.printf("OK!!\r\n");
    }
    
    
    //データ取得＆テキストデータとして書き込み
    int data_int;
    float data_float;
    double data_double;
    bool data_bool;
    char data_char;
    short data_short;
    long long data_longlong;
    
    int data_count, data_size, data_print = 0;
    
    pc.printf("Data Encoding [Binary -> Text].");
    
    while(1){
        for(data_count = 0; data_count < format_length_n; data_count ++){
            switch(format_length[data_count]){
                case DATA_INT:
                data_size = fread(&data_int, sizeof(int), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%d\t", data_int);
                }
                break;
                
                case DATA_FLOAT:
                data_size = fread(&data_float, sizeof(float), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%f\t", data_float);
                }
                break;
                
                case DATA_DOUBLE:
                data_size = fread(&data_double, sizeof(double), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%lf\t", data_double);
                }
                break;
                
                case DATA_BOOL:
                data_size = fread(&data_bool, sizeof(bool), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%d\t", data_bool);
                }
                break;
                
                case DATA_CHAR:
                data_size = fread(&data_char, sizeof(char), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%c\t", data_char);
                }
                break;
                
                case DATA_SHORT:
                data_size = fread(&data_short, sizeof(short), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%hd\t", data_short);
                }
                break;
                
                case DATA_LONGLONG:
                data_size = fread(&data_longlong, sizeof(long long), 1, file_bin);
                if(data_size != 0){
                    fprintf(file_out, "%lld\t", data_longlong);
                }
                break;
            }
        }
        
        if(data_print ++ == 1000){
            pc.printf(".");
            data_print = 0;
        }
        
        fprintf(file_out, "\r\n");
        if(data_size == 0){
            break;
        }
    }
    
    pc.printf("Complete!!\r\n");
    
    
    //終了
    fclose(file_bin);
    fclose(file_out);
    
    pc.printf("Program Finish!!\r\n");
    
    while(1) {
    }
}
