/*********************************************************
    開発理念
        内部でバッファを持って，そのバッファに値を次々に入れていく
        関数を作って，送信関数をつかうと送信するようにする．

**********************************************************/

#ifndef _24FC1025_I2C_H_
#define _24FC1025_I2C_H_
#include "mbed.h"
#define  CONTROL_BYTE  0xA0
#define  SEGMENT0 0x00
#define  SEGMENT1 0x08//0b00001000
/**
*  @bref  Class to use 24FC1025 EEPROM
*/
class EEPROM_24FC1025{
    public:
        /**
        *  @bref  EEPROM 24FC1025 Class's constructor
        *  @param i2cBus  user's using I2C bus constructor
        *  @param A0  A0 pin connection, HIGH:1, LOW:0
        *  @param A1  A1 pin connection, HIGH:1, LOW:0
        */
        EEPROM_24FC1025(I2C &i2cBus, int A0, int A1);
    private:
        I2C *_i2c;
        uint8_t uniqueAddr;
        int page_number;
        uint32_t size;
        
    public:
        /**
        *  @bref  check whether address can use or not
        *  @return OK:1 NG:0
        */
        int checkAddr(uint32_t addr);
        
        /**
        *  @bref  read bytes
        *  @return 0:success, -1:failure
        */
        int read(uint32_t regAddr, uint8_t *data, int length);
        
        /**
        *  @bref  write 1byte
        *
        */
        int write(uint32_t regAddr, uint8_t data);
        
        /**
        *  @bref  write 4 bytes
        */
        int write4Bytes(uint32_t regAddr, uint8_t *data);
        
        /**
        *  
        */
        int write8Bytes(uint32_t regAddr, uint8_t *data);
        
        /**
        *  @bref  write 1 page
        */
        int write1Page(uint32_t pageNumber, uint8_t *data);
};

#endif 