#include "EEPROM_24FC1025.h"

EEPROM_24FC1025::EEPROM_24FC1025(I2C &i2cBus, int A0, int A1){
    _i2c = &i2cBus;
    _i2c->frequency(400000);//400kHz
    if(A0 == 0 && A1 == 0){
        uniqueAddr = 0b00000000; 
    }
    else if(A0 == 1 && A1 == 0){
        uniqueAddr = 0b00000010;   
    }
    else if(A0 == 0 && A1 == 1){
        uniqueAddr = 0b00000100;   
    } 
    else if(A0 == 1 && A1 == 1){
        uniqueAddr = 0b00000110;   
    }
    //for 24FC1025
    size = 131072;//128 kbyte
}

int EEPROM_24FC1025::checkAddr(uint32_t addr){
    if(addr > size) return 0;
    else    return 1;
}

int EEPROM_24FC1025::read(uint32_t regAddr, uint8_t *data, int length){
  
    int slaveAddr;
    char cmd[2];
    int ack = 0;
    
    //check over address
    if(checkAddr(regAddr) == 0) return -1;
    
    //set control byte
    if(regAddr < 0x00010000){
        slaveAddr = (CONTROL_BYTE | SEGMENT0 | uniqueAddr) & 0xFE;//0b10100xx0
    }
    else{
        slaveAddr = (CONTROL_BYTE | SEGMENT1 | uniqueAddr) & 0xFE;//0b10101xx0   
        regAddr -= 0x00010000;
    }
    //set register address
    cmd[0] = (char)(regAddr >> 8);//high byte
    cmd[1] = (char)(regAddr);// & 0xFF);//low byte
    
    //send control byte and register address
    ack = _i2c->write(slaveAddr, cmd, 2, true); 
    if(ack != 0) {
        printf("write error\r\n");
        return;
    }
    //receive date
    slaveAddr = slaveAddr | 0x01;//0b1010yxx1
    ack = _i2c->read(slaveAddr, (char*)&*data, length, false);
    if(ack != 0) {
        printf("read error\r\n");
        return;
    }
    return 0;
    
}

 
int EEPROM_24FC1025::write(uint32_t regAddr, uint8_t data){
    char cmd[3] = {0};
    int slaveAddr = 0;
        //check over address
    if(checkAddr(regAddr) == 0) return -1;
    
    //set control byte
    if(regAddr < 0x00010000){
        slaveAddr = (CONTROL_BYTE | SEGMENT0 | uniqueAddr) & 0xFE;//0b10100xx0
    }
    else{
        slaveAddr = (CONTROL_BYTE | SEGMENT1 | uniqueAddr) & 0xFE;//0b10101xx0   
        regAddr -= 0x00010000;
    }
    cmd[0] = (char)(regAddr >> 8);
    cmd[1] = (char)(regAddr & 0xFF);
    cmd[2] = (char)data;
    
    _i2c->write(slaveAddr, cmd, 3, false);

    return 0;
}