#include "mbed.h"
#include "CCS811_lib.h"

CCS811_lib::CCS811_lib(I2C &user_i2c, AD0 ad0){
    i2c = &user_i2c;
    slave = ad0;
    
    i2c -> frequency(400000);
    
    startMeasure();
    changeMeasureMode(MODE1);
}

int CCS811_lib::connectCheck(){
    cmd[0] = CCS_ID;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 1);
    
    if(buff[0] == 0x81){
        return 1;
    }
    else{
        return 0;
    }
}

void CCS811_lib::changeMeasureMode(CCS_MODE mode){
    cmd[0] = CCS_MEAS_MODE;
    cmd[1] = mode;
    i2c -> write(slave << 1, cmd, 2);
}

void CCS811_lib::getData(int *CO2, int *TVOCs){
    cmd[0] = CCS_DATA;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 8);
    
    *CO2 = (buff[0] << 8) | buff[1];
    *TVOCs = (buff[2] << 8) | buff[3];
}

int CCS811_lib::getCO2(){
    cmd[0] = CCS_DATA;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 8);
    
    return (buff[0] << 8) | buff[1];
}

int CCS811_lib::getTVOCs(){
    cmd[0] = CCS_DATA;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 8);
    
    return (buff[2] << 8) | buff[3];
}

void CCS811_lib::startMeasure(){
    cmd[0] = CCS_START;
    i2c -> write(slave << 1, cmd, 1);
}
