#ifndef CCS811_LIB_H_
#define CCS811_LIB_H_

#define CCS_ADDR_LOW 0x5A
#define CCS_ADDR_HIGH 0x5B

#define CCS_ID 0x20

#define CCS_START 0xF4;

#define CCS_MEAS_MODE 0x01
#define CCS_DATA 0x02

class CCS811_lib{
    
    public:
    
    typedef enum{
        AD0_LOW = CCS_ADDR_LOW,
        AD0_HIGH = CCS_ADDR_HIGH
    }AD0;
    
    typedef enum{
        MODE0 = 0x00,
        MODE1 = 0x10,
        MODE2 = 0x20,
        MODE3 = 0x30,
        MODE4 = 0x40
    }CCS_MODE;
    
    CCS811_lib(I2C &user_i2c, AD0 ad0);
    
    int connectCheck();
    
    void changeMeasureMode(CCS_MODE mode);
    
    void getData(int *CO2, int *TVOCs);
    int getCO2();
    int getTVOCs();
    
    
    private:
    I2C *i2c;
    char slave;
    
    char cmd[2];
    char buff[8];
    
    void startMeasure();
    
};

#endif