#ifndef BATTERY_MONITORING_HPP
#define BATTERY_MONITORING_HPP
/**
*  @bref バッテリー電圧クラス
*/
class battery_monitoring{
    
   public:

        battery_monitoring(float minV, float maxV, PinName pin);
   private:
        float _minV;
        float _maxV;
        AnalogIn _analog;
   public:
        float batteryLevel(); 
        float debug();
};

battery_monitoring::battery_monitoring(float minV, float maxV, PinName pin) : _analog(pin){
    _minV = minV;
    _maxV = maxV;   
}

float battery_monitoring::batteryLevel(){
    float v = 0;
    v = _analog.read();
    for(int i = 0; i < 1000; i++){
        v = (v + _analog.read()) / 2.0f;
    }
    v = 3.3f * v;
    return (v - _minV) / ( _maxV - _minV);
}   

float battery_monitoring::debug(){
    return _analog.read();   
}
#endif