#ifndef BNO055_LIB_
#define BNO055_LIB_

/*******************************************************************************
付け加える予定の機能（未実装）
・単位の変更
・オフセットの回り
*******************************************************************************/

#define BNO055_ADDR_LOW 0x28
#define BNO055_ADDR_HIGH 0x29

#define BNO055_CHIP_ID 0x00
#define BNO055_PAGE_ID 0x07

///////////////////////PAGE 0
#define BNO055_ACC_DATA 0x08
#define BNO055_MAG_DATA 0x0E
#define BNO055_GYR_DATA 0x14
#define BNO055_EUL_DATA 0x1A
#define BNO055_QUA_DATA 0x20
#define BNO055_LIA_DATA 0x28
#define BNO055_GRV_DATA 0x2E

#define BNO055_CALIB_STAT 0x35

#define BNO055_OPR_MODE 0x3D
#define BNO055_PWR_MODE 0x3E

#define BNO055_AXIS_MAP_CONFIG 0x41
#define BNO055_AXIS_MAP_SIGN 0x42

///////////////////////PAGE 1
#define BNO055_ACC_CONFIG 0x08

class BNO055_lib{
    
    public:
    
    typedef enum{
        AD0_LOW = BNO055_ADDR_LOW,
        AD0_HIGH = BNO055_ADDR_HIGH
    }AD0;
    
    typedef enum{
        _2G = 0x00,
        _4G = 0x01,
        _8G = 0x02,
        _16G = 0x03
    }ACC_RANGE;
    
    typedef enum{
        CONFIG = 0x00,
        ACCONLY = 0x01,
        MAGONLY = 0x02,
        GYROONLY = 0x03,
        ACCMAG = 0x04,
        ACCGYRO = 0x05,
        MAGGYRO = 0x06,
        AMG = 0x07,
        IMU = 0x08,
        COMPASS = 0x09,
        M4G = 0x0A,
        NDOF_FMC_OFF = 0x0B,
        NDOF = 0x0C
    }OPERATION_MODE;
    
    typedef enum{
        X = 0x00,
        Y = 0x01,
        Z = 0x02
    }AXIS;
    
    BNO055_lib(I2C &user_i2c, AD0 ad0);
    int connectCheck();
    void setAccRange(ACC_RANGE range);
    void setOperationMode(OPERATION_MODE mode);
    void setAxis(AXIS x, AXIS y, AXIS z);
    void setAxisPM(int x_pm, int y_pm, int z_pm);
    
    void getAcc(float *acc);
    void getAcc(double *acc);
    void getMag(float *mag);
    void getMag(double *mag);
    void getGyro(float *gyro);
    void getGyro(double *gyro);
    void getAMG(float *amg);
    void getAMG(double *amg);
    
    void getEuler(float *euler);
    void getEuler(double *euler);
    void getQuart(float *quart);
    void getQuart(double *quart);
    void getEulerFromQ(float *euler);
    void getEulerFromQ(double *euler);
    void getLinearAcc(float *lia);
    void getLinearAcc(double *lia);
    void getGravity(float *grv);
    void getGravity(double *grv);
    
    
    private:
    
    char slave;
    I2C *i2c;
    
    char cmd[2];
    char buff[18];
    short data[4];
    
    double data_d[4];
    double t0, t1, yy;
};


#endif