#ifndef BME280_LIB_H
#define BME280_LIB_H

#define BME_ADDR_LOW 0x76
#define BME_ADDR_HIGH 0x77

#define BME_ID 0xD0

#define BME_CTRL_HUM 0xF2
#define BME_CTRL_MEAS 0xF4
#define BME_CONFIG 0xF5

#define BME_PRESS 0xF7
#define BME_TEMP 0xFA
#define BME_HUM 0xFD

#define BME_COMP1 0x88
#define BME_COMP2 0xE1

class BME280_lib{
    public:
    
    typedef enum{
        AD0_LOW = BME_ADDR_LOW,
        AD0_HIGH = BME_ADDR_HIGH
    }AD0;
    
    typedef enum{
        SLEEP = 0x00,
        FORCED = 0x01,
        NORMAL = 0x03
    }BME_MODE;
    
    BME280_lib(I2C &user_i2c, AD0 ad0);
    
    int connectCheck();
    
    void configMeasure(BME_MODE mode, int temp_over_sampling, int pres_over_sampling, int hum_over_sampling);
    void configFilter(int filter);
    
    void getData(float *temp, float *pres, float *hum);
    float getTemp();
    float getPres();
    float getHum();
    
    float getAlt(float pres_0, float temp_0);
    float getAlt2(float pres_0, float temp_0);
    
    
    private:
    char slave;
    I2C *i2c;
    
    void readCOMP();
    int calcT();
    unsigned int calcP();
    unsigned int calcH();
    
    char cmd[2];
    char buff[26];
    int adc;
    
    float pres, temp, hum;
    
    unsigned short dig_T1;
    short dig_T2, dig_T3;
    unsigned short dig_P1;
    short dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
    unsigned char dig_H1;
    short dig_H2;
    unsigned char dig_H3;
    short dig_H4, dig_H5;
    char dig_H6;
    int t_fine;
    
    int T_var1, T_var2, T, v_x1;
    long long P_var1, P_var2, P;
};

#endif