#include "mbed.h"
#include "BME280_lib.h"

BME280_lib::BME280_lib(I2C &user_i2c, AD0 ad0){
    i2c = &user_i2c;
    slave = ad0;
    
    i2c -> frequency(400000);
    
    configMeasure(NORMAL, 1, 1, 1);
    configFilter(0);
    
    readCOMP();
}

int BME280_lib::connectCheck(){
    cmd[0] = BME_ID;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 1);
    
    if(buff[0] == 0x60){
        return 1;
    }
    else{
        return 0;
    }
}

void BME280_lib::configMeasure(BME_MODE mode, int temp_over_sampling, int pres_over_sampling, int hum_over_sampling){
    cmd[0] = BME_CTRL_HUM;
    switch(hum_over_sampling){
        case 0:
        cmd[1] = 0x00;
        break;
        
        case 1:
        cmd[1] = 0x01;
        break;
        
        case 2:
        cmd[1] = 0x02;
        break;
        
        case 4:
        cmd[1] = 0x03;
        break;
        
        case 8:
        cmd[1] = 0x04;
        break;
        
        case 16:
        cmd[1] = 0x05;
        break;
        
        default:
        cmd[1] = 0x00;
    }
    i2c -> write(slave << 1, cmd, 2);
    
    cmd[0] = BME_CTRL_MEAS;
    cmd[1] = mode;
    switch(pres_over_sampling){
        case 0:
        cmd[1] = cmd[1] | (0x00 << 2);
        break;
        
        case 1:
        cmd[1] = cmd[1] | (0x01 << 2);
        break;
        
        case 2:
        cmd[1] = cmd[1] | (0x02 << 2);
        break;
        
        case 4:
        cmd[1] = cmd[1] | (0x03 << 2);
        break;
        
        case 8:
        cmd[1] = cmd[1] | (0x04 << 2);
        break;
        
        case 16:
        cmd[1] = cmd[1] | (0x05 << 2);
        break;
        
        default:
        cmd[1] = cmd[1] | (0x00 << 2);
    }
    switch(temp_over_sampling){
        case 0:
        cmd[1] = cmd[1] | (0x00 << 5);
        break;
        
        case 1:
        cmd[1] = cmd[1] | (0x01 << 5);
        break;
        
        case 2:
        cmd[1] = cmd[1] | (0x02 << 5);
        break;
        
        case 4:
        cmd[1] = cmd[1] | (0x03 << 5);
        break;
        
        case 8:
        cmd[1] = cmd[1] | (0x04 << 5);
        break;
        
        case 16:
        cmd[1] = cmd[1] | (0x05 << 5);
        break;
        
        default:
        cmd[1] = cmd[1] | (0x00 << 5);
    }
    i2c -> write(slave << 1, cmd, 2);
}

void BME280_lib::configFilter(int filter){
    cmd[0] = BME_CONFIG;
    switch(filter){
        case 0:
        cmd[1] = 0x00 << 2;
        break;
        
        case 1:
        cmd[1] = 0x01 << 2;
        break;
        
        case 2:
        cmd[1] = 0x02 << 2;
        break;
        
        case 4:
        cmd[1] = 0x03 << 2;
        break;
        
        case 8:
        cmd[1] = 0x04 << 2;
        break;
        
        case 16:
        cmd[1] = 0x05 << 2;
        break;
        
        default:
        cmd[1] = 0x00;
        break;
    }
    i2c -> write(slave << 1, cmd, 2);
}

void BME280_lib::getData(float *temp, float *pres, float *hum){
    cmd[0] = BME_TEMP;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 3);
    adc = (buff[0] << 12) | (buff[1] << 4) | (buff[0] >> 4);
    *temp = (float)calcT() / 100.0;
    
    cmd[0] = BME_PRESS;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 3);
    adc = (buff[0] << 12) | (buff[1] << 4) | (buff[0] >> 4);
    *pres = (float)calcP() / 256.0 / 100.0;
    
    cmd[0] = BME_HUM;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 3);
    adc = (buff[0] << 8) | buff[1];
    *hum = (float)calcH() / 1024.0;
}

float BME280_lib::getTemp(){
    getData(&temp, &pres, &hum);
    return temp;
}

float BME280_lib::getPres(){
    getData(&temp, &pres, &hum);
    return pres;
}

float BME280_lib::getHum(){
    getData(&temp, &pres, &hum);
    return hum;
}

float BME280_lib::getAlt(float pres_0, float temp_0){
    pres = getPres();
    return -(273.0 + temp_0) / 0.0342 * log(pres / pres_0);
}

float BME280_lib::getAlt2(float pres_0, float temp_0){
    pres = getPres();
    return (273.0 + temp_0) / 0.0065 * (1.0 - (float)pow((double)(pres / pres_0), 0.190));
}


void BME280_lib::readCOMP(){
    cmd[0] = BME_COMP1;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 25);
    dig_T1 = buff[0] | (buff[1] << 8);
    dig_T2 = buff[2] | (buff[3] << 8);
    dig_T3 = buff[4] | (buff[5] << 8);
    dig_P1 = buff[6] | (buff[7] << 8);
    dig_P2 = buff[8] | (buff[9] << 8);
    dig_P3 = buff[10] | (buff[11] << 8);
    dig_P4 = buff[12] | (buff[13] << 8);
    dig_P5 = buff[14] | (buff[15] << 8);
    dig_P6 = buff[16] | (buff[17] << 8);
    dig_P7 = buff[18] | (buff[19] << 8);
    dig_P8 = buff[20] | (buff[21] << 8);
    dig_P9 = buff[22] | (buff[23] << 8);
    dig_H1 = buff[24];
    
    cmd[0] = BME_COMP2;
    i2c -> write(slave << 1, cmd, 1);
    i2c -> read(slave << 1 | 1, buff, 7);
    dig_H2 = buff[0] | (buff[1] << 8);
    dig_H3 = buff[2];
    dig_H4 = (buff[3] << 4) | (buff[4] & 0x0F);
    dig_H5 = ((buff[4] >> 4) & 0x0F) | (buff[5] << 4);
    dig_H6 = buff[6];   
}

int BME280_lib::calcT(){
    T_var1 = ((((adc >> 3) - ((int)dig_T1 << 1))) * ((int)dig_T2)) >> 11;
    T_var2 = (((((adc >> 4) - ((int)dig_T1)) * ((adc >> 4) - ((int)dig_T1))) >> 12) * ((int)dig_T3)) >> 14;
    t_fine = T_var1 + T_var2;
    T = (t_fine * 5 + 128) >> 8;
    return T;
}

unsigned int BME280_lib::calcP(){
    P_var1 = ((long long)t_fine) - 128000;
    P_var2 = P_var1 * P_var1 * (long long)dig_P6;
    P_var2 = P_var2 + ((P_var1 * (long long)dig_P5) << 17);
    P_var2 = P_var2 + (((long long)dig_P4) << 35);
    P_var1 = ((P_var1 * P_var1 * (long long)dig_P3) >> 8) + ((P_var1 * (long long)dig_P2) << 12);
    P_var1 = (((((long long)1) << 47) + P_var1)) * ((long long)dig_P1) >> 33;
    if(P_var1 == 0){
        return 0;
    }
    P = 1048576 - adc;
    P = (((P << 31) - P_var2) * 3125) / P_var1;
    P_var1 = (((long long)dig_P9) * (P >> 13) * (P >> 13)) >> 25;
    P_var2 = (((long long)dig_P8) * P) >> 19;
    P = ((P + P_var1 + P_var2) >> 8) + (((long long)dig_P7) << 4);
    return (unsigned int)P;
}

unsigned int BME280_lib::calcH(){
    v_x1 = (t_fine - ((int)76800));
    v_x1 = (((((adc << 14) - (((int)dig_H4) << 20) - (((int)dig_H5) * v_x1)) + 
            ((int)16384)) >> 15) * (((((((v_x1 * ((int)dig_H6)) >> 10) * 
            (((v_x1 * ((int)dig_H3)) >> 11) + ((int)32768))) >> 10) + 
            ((int)2097152)) * ((int)dig_H2) + 8192) >> 14));
    v_x1 = (v_x1 - (((((v_x1 >> 15) * (v_x1 >> 15)) >> 7) * ((int)dig_H1)) >> 4));
    v_x1 = (v_x1 < 0 ? 0 : v_x1);
    v_x1 = (v_x1 > 419430400 ? 419430400 : v_x1);
    return (unsigned int)(v_x1 >> 12);
}
