/***************************************************************
    ILI9340_Driver  v1.1    26.05.14    Ian Weston
    
Demo project to demonstrate the ILI9340 display driver and graphics
library in action. very simple, good base for any project.    

About the Library:

Driver and integrated graphics library for displays that use the 
ILI9340 controller in SPI mode.

The code was prted from several sources, the driver section
was completely ported from the Adafruits Arduino source code, and
the graphics functions were ported from the Adafruits GFX library
and some elements were ported from code by Elmicros seeduio port.

Future revisions will include more advanced graphics functions.

Rough and ready Demo code to for showing the driver and some 
functions in action.

***************************************************************/


#include "mbed.h"
#include "ILI9340_Driver.h"


int main() {

    // create the display object
    ILI9340_Display tft = ILI9340_Display(D11, D12, D13, D4, D2, D7); // mosi,miso,slck,cs,rst,dc

    // initialise the display
    tft.DispInit();
    
    // clears the screen to remove all noise data
    tft.FillScreen(ILI9340_WHITE);
        


    // set up variables for graphics functions
    uint16_t c1, c2, c3, c4, c5, c6;
    uint8_t r = 0, g = 0, b = 0;
    char elapsed[] = "1111";
    int counter = 0;

    // variables for the 'waiting..' squares
    int red[] = {0,30,60,90,120};
    int green[] = {0,30,60,90,120};
    int blue[] = {0,30,60,90,120};
    
    tft.InvertDisplay (true);
    
    while(true) {    
        // draws a black window
        tft.DrawRect(20, 20, 200, 280, ILI9340_BLACK);
    
        // Small amount of text to the display.
        tft.DrawString("Hello ILI9340 Lib!", 50, 120, 1, ILI9340_BLACK);
        tft.DrawString("Frame Count:", 70, 135, 1, ILI9340_BLACK);
        tft.DrawString("Go Create!", 45, 210, 2, ILI9340_BLUE);
        

        
    
        // convert the RGB values into values that can be writen to the screen
        c1 = tft.Colour565(r, g, b);
        c2 = tft.Colour565(red[0], green[0], blue[0]);
        c3 = tft.Colour565(red[1], green[1], blue[1]);
        c4 = tft.Colour565(red[2], green[2], blue[2]);
        c5 = tft.Colour565(red[3], green[3], blue[3]);
        c6 = tft.Colour565(red[4], green[4], blue[4]);
        
        // Print a 'waiting..' animation to the screen.
        tft.FillRect( 30, 60, 20, 20, c6);
        tft.FillRect( 70, 60, 20, 20, c5);
        tft.FillRect( 110, 60, 20, 20, c4);
        tft.FillRect( 150, 60, 20, 20, c3);
        tft.FillRect( 190, 60, 20, 20, c2);
        
        // change the RGB vlaues for circle effect
        r += 4; g += 6; b += 8; 
        
        // change RGB values for the 'waiting' animation effect
        for (int i = 0; i < 5; i++) {
            red[i]   += 5;
            green[i] += 5;
            blue[i]  += 5;
            }
        
               
        //Write the frame count to screen, first overwriting the previos value in the background colour
        tft.IntToChars(elapsed, counter, 4, 10, 70, 160, 3, ILI9340_WHITE);
        if (counter++ > 9999) {counter = 0;}
        tft.IntToChars(elapsed, counter, 4, 10, 70, 160, 3, ILI9340_RED);
        
        // Draw the circle ripples to the screen
        tft.DrawCircle(120, 265, r, c1);
        
        
        // Do the waiting thang...
        wait(0.025);

    }

}

