// main.h

// pinout
#define DEBUG_TX    PA_2
#define DEBUG_RX    PA_3

#define SPI_SCK     PA_5
#define SPI_MISO    PA_6 
#define SPI_MOSI    PA_7

#define SD_CSN      PB_1
#define SD_MISO     PC_2
#define SD_MOSI     PC_3
#define SD_SCK      PB_13

#define DRDY1A      PA_4
#define DRDY1B      PA_8
#define DRDY1C      PB_2
#define DRDY2A      PB_10
#define DRDY2B      PB_11
#define DRDY2C      PB_14

#define SSM1A       PC_6
#define SSM1B       PC_7
#define SSM1C       PC_9
#define SSM2A       PC_10
#define SSM2B       PC_11
#define SSM2C       PC_13

#define DEBUG_LED   PA_9
#define DEBUG_MODE  PA_10

#define MAG_REG     (0)     // single mag measurment
#define CMM_REG     (1)     // continuous measurement mode
#define CC_REG      (4)     // Cycle Count Register
#define TMRC_REG    (0x0b)  // Timer registers for continuous meas rate
#define MX_REG      (0x24)  // results for the X-axis
#define MY_REG      (0x27)  // results for the Y-axis
#define MZ_REG      (0x2a)  // results for the Z-axis
#define BIST_REG    (0x33)  // BIST register set to 0x80 before MAG_REG
#define STAT_REG    (0x34)  // Status register. mask with 0x80 to read DRDY state

#define ALL_AXES    (0x70)  // Enable and start meas of all 3 axes
#define START_BIT   (0x01)