/* mbed USBJoystick Library Demo
 * Copyright (c) 2012, v01:  Initial version, WH,
 *                           Modified USBMouse code ARM Limited.
 *                           (c) 2010-2011 mbed.org, MIT License
 *               2016, v02:  Updated USBDevice Lib, Added waitForConnect, Updated 32 bits button
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, inclumosig without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUmosiG BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// Note: you must connect the usb cable to your computer before the program will proceed

// USB parts from: https://developer.mbed.org/forum/helloworld/topic/3496/

#include "mbed.h"
#include "USBKeyboard.h"

//USBMouse mouse;
USBKeyboard mbedKeyBoard;
// Variables for Heartbeat and Status monitoring
PwmOut myled1(LED1);
PwmOut myled2(LED2);
PwmOut myled3(LED3);
DigitalOut heartbeatLED(LED4);
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut MOSFET(PA_4);      // Connected to Gate of MOSFET
AnalogIn   VBin(PA_1);        // To measure battery Voltage
DigitalOut LED(D4);           // Activity indicator
DigitalIn enable(PA_5);

#define WIRE_LEAD_RES (0.23F)
// BOARD SPECIFIC CALIBRATION CONSTANTS
#define BOARDNUMBER 1
#if BOARDNUMBER == 1
#define V_SCALE  3.735935F
#elif BOARDNUMBER == 2
#define V_SCALE 3.3F
#elif BOARDNUMBER == 3
#define V_SCALE 3.3F
#else
#define V_SCALE 3.3F
#endif
// Parameters
#define PULSEWIDTH  1.0f  // seconds
char    serial_inchar,waiting;

void OnSerial(void) // serial port interrupt used in calibration mode
{
    serial_inchar = pc.getc();
    waiting = 0;
}

int main()
{

    float OpenVoltage, LoadVoltage, Esr;
    pc.baud(115200);
    printf("Battery ESR Tester\n\r");
    pc.attach(&OnSerial);
    MOSFET = 0;
    LED = 0;
    
#if 1  // 0 = Calibration Mode, 1= Discharge test mode  

    printf("Test Mode\n\r");

    while(1) {

        waiting = 1;

        while(enable) {
            wait(0.1);
        }
        mbedKeyBoard.printf("Test running: ");
        printf("Test running: ");
        wait(3); //debounce and force a minimum time between tests to ensure the battery has time to recovery.
        OpenVoltage = VBin.read()* V_SCALE;
        LED = 1;
        MOSFET = 1;
        wait(PULSEWIDTH);
        LoadVoltage = VBin.read()* V_SCALE;
        LED = 0;
        MOSFET = 0;
        Esr = (OpenVoltage-LoadVoltage)/(LoadVoltage / 3.0f)- WIRE_LEAD_RES;
        mbedKeyBoard.printf("Open Voltage = %1.3f, Loaded Voltage = %1.3f, ESR = %1.3f\n\r",
                            OpenVoltage, LoadVoltage, Esr);
        printf("Open Voltage = %1.3f, Loaded Voltage = %1.3f, ESR = %1.3f\n\r",
               OpenVoltage, LoadVoltage, Esr);
    }

#else

    //Perform Board Calibration
    printf("\n\rCalibration Mode\n\r");
    waiting = 1;

    while (pc.readable()) { // flush buffer
        serial_inchar = pc.getc();
    }

    printf("Set Vin to 3.600V then [press any key]\n\r");

    while(waiting == 1) {
        wait(0.05);
    }

    printf("Reading...\n\r");
    wait(0.5);
    OpenVoltage = VBin.read();
    printf("Cut/paste this calibration into the calibration section...\n\r\n\r");
    printf("#define V_SCALE %fF\n\r",3.6/OpenVoltage);

#endif

}