#include "mbed.h"
#include "Chirp.h"
 
Chirp chirp(D14, D15); 
const int addr7bit = 0x48;      // 7 bit I2C address
const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
 
//Chirp Docs are at https://github.com/Miceuz/i2c-moisture-sensor and https://www.tindie.com/products/miceuz/i2c-soil-moisture-sensor/
void getResults();
Chirp::Chirp(PinName sda, PinName scl, char slave_adr)
    :i2c_p(new I2C(sda, scl)), i2c(*i2c_p), address(slave_adr)
{
    i2c.frequency(10000);
    
}

float Chirp::getCapacitance(){
    i2c.frequency(10000);
    short capacitance = 0;
    char i2cData[2]; 
    
    char dataReg = 0; //Capacitance is stored in 2 bytes at address 0
    char cmd[2];
    
    i2cData[0] = 0x01;
    i2cData[1] = 0x00;
    int test = i2c.write(addr8bit, cmd, 2);
    printf("%i\n\n", test);
    ThisThread::sleep_for(500);
    cmd[0] = 0x00;
    i2c.write(addr8bit, cmd, 1);
    i2c.read(addr8bit, cmd, 2);
    float tmp = (float((cmd[0] << 8) | cmd[1]) / 256.0);
    printf("Temp = %.2f\n", tmp); 
    
    
    int master = i2c.write(address, &dataReg, 1); 
    printf("%i\n\n", master);
    int success = i2c.read(address, i2cData, 2);
     printf("%i\n\n", success);
    
    if(success != 1)
        return -1000000; 
    else
    {
        //I2C bytes are in different byte order, write into short bytes 0 and 1 in reverse order!
        *((char*)&capacitance) = i2cData[1];
        *(((char*)(&capacitance)) + 1) = i2cData[0];
        return capacitance;
    }}
 
float Chirp::getTemperature(){
    i2c.frequency(10000);
    short temperature = 0;
    char i2cData[2]= {0}; 
    
    
    char dataReg = 4; //Temperature is stored in 2 bytes at address 5
    int master = i2c.write(address, &dataReg, 1); 
    printf("%i\n\n", master);
    int success = i2c.read(address, i2cData, 2);
    printf("%i\n\n", success);
    
    
    if(success != 1)
        return -1000000; 
    else
    {
        *((char*)&temperature) = i2cData[1];
        *(((char*)(&temperature)) + 1) = i2cData[0];
        return (float) temperature / 10.0;
    }    }
    
    
void getResults(){ 
    printf("test\n\n");
    printf("Capacitance = %.2f\n", chirp.getCapacitance());
    printf("Temperatur = %.2f\n", chirp.getTemperature());
}