#include "mbed.h"

//Eigene Header einbinden

//include Zeitfunktion
#include "realtimer.h"

//include Servosteuerung
#include "servo_bewegung.h"

//include Feuchtigkeitssensor
#include "Chirp.h"

//include Audio
#include "sprach_out.h"

//LED Anzeige
//#include "clock_display.h"
//#include "Adafruit_LED_Backpack.h"

#define TIME_24_HOUR      true
#define DISPLAY_ADDRESS   0x70

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        //start();
    };
};

 
//I2CPreInit gI2C(PB_9, PB_8);
//Adafruit_7segment clockDisplay = Adafruit_7segment();
//clockDisplay.begin(DISPLAY_ADDRESS);
//bool blinkColon = false;

using namespace std::chrono;

InterruptIn    user_button(USER_BUTTON);
DigitalOut  led(LED1);

//BufferedSerial pc(SERIAL_TX, SERIAL_RX);
//I2C i2c(PB_9, PB_8);     // i2c1 pins

bool  executeMainTask = false;
Timer user_button_timer, loop_timer;

/* declaration of custom button functions */
void button_fall();
void button_rise();


int main()
{
    set_time(1618332129);  //Zeit setzen
    
    //Laufvariablen
    int hours = 0;
    int minutes = 0;
    int seconds = 0;
    
    user_button.fall(&button_fall);
    user_button.rise(&button_rise);
    loop_timer.start();

    while (true) {

        loop_timer.reset();
 
        if (executeMainTask) {
             
            //Zeitfunktion
            uhrzeit(time(NULL));

            //Uhr Anzeige
            //clock_display(seconds, minutes, hours);
            
            switch(seconds){
                //2 Minuten
                case 120:    seconds += 5;
                            //Seesaw Programm
                            getResults();
                            ThisThread::sleep_for(5s); //Wartet 5s..
                            break;
                //5 Minuten
                case 300: {   seconds += 5;
                            bewegung(1);
                            ThisThread::sleep_for(5s); //Wartet 5s..
                            break;
                        }
                //7 Minuten
                case 420:    seconds += 5;
                            bewegung(2);
                            //Audio Signal
                            ThisThread::sleep_for(5s); //Wartet 5s..
                            break;
                //10 Minuten
                case 600:   seconds += 5;
                            bewegung(3);
                            //Audio Signal
                            ThisThread::sleep_for(5s); //Wartet 5s..
                            break;
                default :   seconds += 5;
                            ThisThread::sleep_for(5s); //Wartet 5s..
                            break;
                            }
        
        led = !led;
        
            }
        }
}

void button_fall()
{
    user_button_timer.reset();
    user_button_timer.start();
}

void button_rise()
{
    int t_button_ms = duration_cast<milliseconds>(user_button_timer.elapsed_time()).count();
    user_button_timer.stop();
    if (t_button_ms > 200) {
        executeMainTask = !executeMainTask;
    }
}