/*#include "mbed.h"
#include "Adafruit_LED_Backpack.h"
#include "Adafruit_GFX.h"

#ifndef _BV
#define _BV(bit) (1 << (bit)) ///< Bit-value if not defined by Arduino
#endif

#ifndef _swap_int16_t
#define _swap_int16_t(a, b)                                                    \
  {                                                                            \
    int16_t t = a;                                                             \
    a = b;                                                                     \
    b = t;                                                                     \
  } ///< 16-bit var swap
#endif
BufferedSerial pc(SERIAL_TX, SERIAL_RX);
I2C i2c(PB_9, PB_8);     // i2c1 pins
static const uint8_t numbertable[] = {
    0x3F, /* 0 */
   // 0x06, /* 1 */
   // 0x5B, /* 2 */
    //0x4F, /* 3 */
    //0x66, /* 4 */
//    0x6D, /* 5 */
  //  0x7D, /* 6 */
    //0x07, /* 7 */
//    0x7F, /* 8 */
  //  0x6F, /* 9 */
//    0x77, /* a */
//    0x7C, /* b */
  //  0x39, /* C */
    //0x5E, /* d */
    //0x79, /* E */
  //  0x71, /* F */
//};
/*
//mpl - something with stdio screwing things up.  need to define serial port to use for debug
extern BufferedSerial pc;

void Adafruit_LED_Backpack::setBrightness(uint8_t b) {
  if (b > 15) b = 15;
  uint8_t c = 0xE0 | b;
  char foo[1];
  foo[0] = c;
  _i2c->write(i2c_addr, foo, 1); 
}

void Adafruit_LED_Backpack::blinkRate(uint8_t b) {
  if (b > 3) b = 0; // turn off if not sure
  uint8_t c = HT16K33_BLINK_CMD | HT16K33_BLINK_DISPLAYON | (b << 1);
  char foo[1];
  foo[0] = c;
  _i2c->write(i2c_addr, foo, 1);
}

Adafruit_LED_Backpack::Adafruit_LED_Backpack(I2C *i2c): _i2c(i2c) {
}

void Adafruit_LED_Backpack::begin(uint8_t _addr = 0x70) {
  i2c_addr = _addr << 1;

  char foo[1];
  foo[0] = 0x21;

  _i2c->write(i2c_addr, foo, 1);  // turn on oscillator

  blinkRate(HT16K33_BLINK_OFF);
  
  setBrightness(15); // max brightness
}

void Adafruit_LED_Backpack::writeDisplay(void) {
  char foo[17];
  foo[0] = 0x00;
  int j = 0;
  for (uint8_t i=1; i<=16; i+=2) {
    int x = displaybuffer[j] & 0xFF;
    foo[i] = x;
    int x2 = displaybuffer[j] >> 8;
    foo[i+1] = x2;
    j++;
  }
  _i2c->write(i2c_addr, foo, 17);
}

void Adafruit_LED_Backpack::clear(void) {
  for (uint8_t i=0; i<16; i++) {
    displaybuffer[i] = 0;
  }
}



Adafruit_7segment::Adafruit_7segment(void) { position = 0; }

void Adafruit_7segment::print(unsigned long n, int base) {
  if (base == 0)
    write(n);
  else
    printNumber(n, base);
}

void Adafruit_7segment::print(char c, int base) { print((long)c, base); }

void Adafruit_7segment::print(unsigned char b, int base) {
  print((unsigned long)b, base);
}

void Adafruit_7segment::print(int n, int base) { print((long)n, base); }

void Adafruit_7segment::print(unsigned int n, int base) {
  print((unsigned long)n, base);
}

void Adafruit_7segment::println(void) { position = 0; }

void Adafruit_7segment::println(char c, int base) {
  print(c, base);
  println();
}

void Adafruit_7segment::println(unsigned char b, int base) {
  print(b, base);
  println();
}

void Adafruit_7segment::println(int n, int base) {
  print(n, base);
  println();
}

void Adafruit_7segment::println(unsigned int n, int base) {
  print(n, base);
  println();
}

void Adafruit_7segment::println(long n, int base) {
  print(n, base);
  println();
}

void Adafruit_7segment::println(unsigned long n, int base) {
  print(n, base);
  println();
}

void Adafruit_7segment::println(double n, int digits) {
  print(n, digits);
  println();
}

void Adafruit_7segment::print(double n, int digits) { printFloat(n, digits); }

size_t Adafruit_7segment::write(uint8_t c) {

  uint8_t r = 0;

  if (c == '\n')
    position = 0;
  if (c == '\r')
    position = 0;

  if ((c >= '0') && (c <= '9')) {
    writeDigitNum(position, c - '0');
    r = 1;
  }

  position++;
  if (position == 2)
    position++;

  return r;
}

void Adafruit_7segment::writeDigitRaw(uint8_t d, uint8_t bitmask) {
  if (d > 4)
    return;
  displaybuffer[d] = bitmask;
}

void Adafruit_7segment::drawColon(bool state) {
  if (state)
    displaybuffer[2] = 0x2;
  else
    displaybuffer[2] = 0;
}

void Adafruit_7segment::writeColon(void) {
  i2c.beginTransmission(i2c_addr);
  Wire.write((uint8_t)0x04); // start at address $02

  Wire.write(displaybuffer[2] & 0xFF);
  Wire.write(displaybuffer[2] >> 8);

  Wire.endTransmission();
}

void Adafruit_7segment::writeDigitNum(uint8_t d, uint8_t num, bool dot) {
  if (d > 4)
    return;

  writeDigitRaw(d, numbertable[num] | (dot << 7));
}

void Adafruit_7segment::print(long n, int base) { printNumber(n, base); }

void Adafruit_7segment::printNumber(long n, uint8_t base) {
  printFloat(n, 0, base);
}

void Adafruit_7segment::printFloat(double n, uint8_t fracDigits, uint8_t base) {
  uint8_t numericDigits = 4; // available digits on display
  bool isNegative = false;   // true if the number is negative

  // is the number negative?
  if (n < 0) {
    isNegative = true; // need to draw sign later
    --numericDigits;   // the sign will take up one digit
    n *= -1;           // pretend the number is positive
  }

  // calculate the factor required to shift all fractional digits
  // into the integer part of the number
  double toIntFactor = 1.0;
  for (int i = 0; i < fracDigits; ++i)
    toIntFactor *= base;

  // create integer containing digits to display by applying
  // shifting factor and rounding adjustment
  uint32_t displayNumber = n * toIntFactor + 0.5;

  // calculate upper bound on displayNumber given
  // available digits on display
  uint32_t tooBig = 1;
  for (int i = 0; i < numericDigits; ++i)
    tooBig *= base;

  // if displayNumber is too large, try fewer fractional digits
  while (displayNumber >= tooBig) {
    --fracDigits;
    toIntFactor /= base;
    displayNumber = n * toIntFactor + 0.5;
  }

  // did toIntFactor shift the decimal off the display?
  if (toIntFactor < 1) {
    printError();
  } else {
    // otherwise, display the number
    int8_t displayPos = 4;

    if (displayNumber) // if displayNumber is not 0
    {
      for (uint8_t i = 0; displayNumber || i <= fracDigits; ++i) {
        bool displayDecimal = (fracDigits != 0 && i == fracDigits);
        writeDigitNum(displayPos--, displayNumber % base, displayDecimal);
        if (displayPos == 2)
          writeDigitRaw(displayPos--, 0x00);
        displayNumber /= base;
      }
    } else {
      writeDigitNum(displayPos--, 0, false);
    }

    // display negative sign if negative
    if (isNegative)
      writeDigitRaw(displayPos--, 0x40);

    // clear remaining display positions
    while (displayPos >= 0)
      writeDigitRaw(displayPos--, 0x00);
  }
}

void Adafruit_7segment::printError(void) {
  for (uint8_t i = 0; i < SEVENSEG_DIGITS; ++i) {
    writeDigitRaw(i, (i == 2 ? 0x00 : 0x40));
  }
}*/