#ifndef __LIBRARY_DFPLAYER_MINI_H__
#define __LIBRARY_DFPLAYER_MINI_H__

#include "mbed.h"


#define DFPLAYER_STX    (0x7E)
#define DFPLAYER_ETX    (0xEF)
#define DFPLAYER_VER    (0xFF)

// typedef  definition
typedef enum _DFPLAYERMINICOM{
    DFPLAYER_NEXT               =   0x01,
    DFPLAYER_PREV               =   0x02,
    DFPLAYER_NUM                =   0x03,
    DFPLAYER_VOL_PLUS           =   0x04,
    DFPLAYER_VOL_MINUS          =   0x05,
    DFPLAYER_VOL_SET            =   0x06,
    DFPLAYER_EQ                 =   0x07,
    DFPLAYER_PLAYBACKMODE       =   0x08,
    DFPLAYER_PLAYBACKSOURCE     =   0x09,
    DFPLAYER_STANDBY            =   0x0A,
    DFPLAYER_NORMAL             =   0x0B,
    DFPLAYER_RESET              =   0x0C,
    DFPLAYER_PLAYBACK           =   0x0D,
    DFPLAYER_PAUSE              =   0x0E,
    DFPLAYER_PLAYBACKFOLDER     =   0x0F,
    DFPLAYER_VOLADJUSTSET       =   0x10,
    DFPLAYER_REPEATPLAY         =   0x11,   
    DFPLAYER_STAY1              =   0x3C,
    DFPLAYER_STAY2              =   0x3D,
    DFPLAYER_STAY3              =   0x3E,
    DFPLAYER_INITIALIZE         =   0x3F,
    DFPLAYER_ERROR              =   0x40,
    DFPLAYER_REPLY              =   0x41,
    DFPLAYER_CSTATUS            =   0x42,
    DFPLAYER_CVOLUME            =   0x43,
    DFPLAYER_CEQ                =   0x44,
    DFPLAYER_CPLAYBACKMODE      =   0x45,
    DFPLAYER_VERSION            =   0x46,
    DFPLAYER_TFFILES            =   0x47,
    DFPLAYER_UDISKFILES         =   0x48,
    DFPLAYER_FLASHFILES         =   0x49,
    DFPLAYER_KEEPON             =   0x4A,
    DFPLAYER_CTFTRACK           =   0x4B,
    DFPLAYER_CUDISKTRACK        =   0x4C,
    DFPLAYER_CFLASHTRACK        =   0x4D
} DFPLAYERMINICOM;

typedef void (*BUSYFUNCPTR)(void);

class DFPlayerMini{
    public:
        DFPlayerMini( PinName busy, PinName tx, PinName rx );   // constructor
        ~DFPlayerMini();                                        // destructor
        
        void begin();
        void attachBusyInterrupt( BUSYFUNCPTR func );
        void playNext();
        void playPrev();
        void playNumber( uint16_t num );
        void playFolder( uint8_t folder, uint8_t num );
        void volumePlus();
        void volumeMinus();
        void volumeSet( uint8_t vol );
            
    private:
        InterruptIn _busy;
        BufferedSerial _serial;
        BUSYFUNCPTR _func;
        
        void _send_command( DFPLAYERMINICOM com, uint8_t param1, uint8_t param2 );
};

#endif