#include "mbed.h"
#include "PWM.h"

Timeout timer;
Timeout timer2;

DigitalOut my_pwm(D10); // IO used by pwm_io function
DigitalOut my_pwm2(D5);


int on_delay = 0;
int off_delay = 0;
int on_delay2 = 0;
int off_delay2 = 0;

void toggleOff(void);

void toggleOn(void) {
    my_pwm = 1;
    timer.attach_us(toggleOff, on_delay);
}

void toggleOff(void) {
    my_pwm = 0;
    timer.attach_us(toggleOn, off_delay);
}

// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
void pwm_io(int p_us, float dc) {
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        my_pwm = 0;
        return;
    }
    if (dc >= 1) {
        my_pwm = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn();
}

////PMW2
void toggleOff2(void);

void toggleOn2(void) {
    my_pwm2 = 1;
    timer2.attach_us(toggleOff2, on_delay2);
}

void toggleOff2(void) {
    my_pwm2 = 0;
    timer2.attach_us(toggleOn2, off_delay2);
}

// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
void pwm_io2(int p_us, float dc) {
    timer2.detach();
    if ((p_us == 0) || (dc == 0)) {
        my_pwm2 = 0;
        return;
    }
    if (dc >= 1) {
        my_pwm2 = 1;
        return;
    }
    on_delay2 = (int)(p_us * dc);
    off_delay2 = p_us - on_delay2;
    toggleOn2();
}




