#ifndef STEPPER_H
#define STEPPER_H

#include "mbed.h"
#include "DevSPI.h"
#include "L6470_def.h"
#include "StepperMotor.h"

/* ----------------------- LEERLAUF ----------------------------------------- */
void Stepper_1_Leerlauf();
void Stepper_2_Leerlauf();
void Stepper_3_Leerlauf();
void Stepper_4_Leerlauf();
/* ---------------------------- END ----------------------------------------- */




/* -------------------------- STOP ------------------------------------------ */
void Stepper_1_Stop();
void Stepper_2_Stop();
void Stepper_3_Stop();
void Stepper_4_Stop();
/* ---------------------------- END ----------------------------------------- */




/* ----------------------- SET_HOME_POSITION -------------------------------- */
/* Legt akutelle Postion als Home fest und setzt Stepper-Count auf 0 */
void Stepper_1_SetHome();                       
void Stepper_2_SetHome();                       
void Stepper_3_SetHome();                       
void Stepper_4_SetHome();

/* Fährt auf dem kürzesten Weg nach Home zurück */
void Stepper_1_GoHome();
void Stepper_2_GoHome();
void Stepper_3_GoHome();
void Stepper_4_GoHome();
/* ---------------------------- END ----------------------------------------- */





/* ----------------------- MARK_POSITION ------------------------------------ */
/* Markiert aktuelle Position des Steppers, setzt Stepper-Count NICHT auf 0 */
void Stepper_1_MarkPos();
void Stepper_2_MarkPos();
void Stepper_3_MarkPos();
void Stepper_4_MarkPos();

/* Fährt auf dem kürzesten Weg zur markierten Postion zurück */
void Stepper_1_GoMark();
void Stepper_2_GoMark();
void Stepper_3_GoMark();
void Stepper_4_GoMark();

/* Gibt Position welche markiert wurden zurück */ /*
int Stepper_1_GetMark();
int Stepper_1_GetMark();                            // Braucht man eigentlich nicht
int Stepper_1_GetMark();                
int Stepper_1_GetMark();*/
/* ---------------------------- END ----------------------------------------- */




/* ---------------------------- ANY_POSITION -------------------------------- */
/* Gibt aktuelle Position des Steppers zurück */
int Stepper_1_GetPosition();
int Stepper_2_GetPosition();
int Stepper_3_GetPosition();
int Stepper_4_GetPosition();

/* Fährt automatisch zur markierten Postion */
void Stepper_1_GoTo(signed int position);
void Stepper_2_GoTo(signed int position);
void Stepper_3_GoTo(signed int position);
void Stepper_4_GoTo(signed int position);
/* ---------------------------- END ----------------------------------------- */




/* --------------------------------- MOVE ----------------------------------- */
/* Richtung angeben und Anzahl Steps */
/* V = Vorwärts  */
/* R = Rückwärts */

void Stepper_1_Move(char direction, unsigned int steps);
void Stepper_2_Move(char direction, unsigned int steps);
void Stepper_3_Move(char direction, unsigned int steps);
void Stepper_4_Move(char direction, unsigned int steps);
/* ---------------------------- END ----------------------------------------- */




/* --------------------------------- RUN ------------------------------------ */
/* Richtung angeben und Geschwindigkeit */
/* V = Vorwärts  */
/* R = Rückwärts */
void Stepper_1_Run(char direction, unsigned int speed);
void Stepper_2_Run(char direction, unsigned int speed);
void Stepper_3_Run(char direction, unsigned int speed);
void Stepper_4_Run(char direction, unsigned int speed);
/* ---------------------------- END ----------------------------------------- */






#endif
