#include "SETUP.h"


DigitalOut RS(DISP_RS);
DigitalOut RW(DISP_RW);
DigitalOut E(DISP_E);
DigitalOut bit0(DISP_B0);
DigitalOut bit1(DISP_B1);
DigitalOut bit2(DISP_B2);
DigitalOut bit3(DISP_B3);
DigitalOut bit4(DISP_B4);
DigitalOut bit5(DISP_B5);
DigitalOut bit6(DISP_B6);
DigitalOut bit7(DISP_B7);

/**************************************************************
Sendebefehls-Funktion für das Display MIDAS
E=Enable, RS= Register Select Signal, RW= Data Read/Wirte
Siehe MIDAS Datasheet 6.3.1 Write Mode Timing Diagramm
**************************************************************/
void DisplaySendeBefehl(unsigned char befehl)
{
    RW=0;
    E=0;
    RS=0;
    wait_us(1);                     //delay>0
    E=1;
    wait_ms(1);  
    bit0= (befehl>>0)&0x01;                 
    bit1= (befehl>>1)&0x01;
    bit2= (befehl>>2)&0x01;
    bit3= (befehl>>3)&0x01;
    bit4= (befehl>>4)&0x01;
    bit5= (befehl>>5)&0x01;
    bit6= (befehl>>6)&0x01;
    bit7= (befehl>>7)&0x01;
    wait_ms(1);
    E=0;
    wait_ms(1);
    RS=0;
    RW=0;
    bit0=0;
    bit1=0;
    bit2=0;
    bit3=0;
    bit4=0;
    bit5=0;
    bit6=0;
    bit7=0;
    wait_ms(1); 
    /*
    PORTB= PORTB & 0b11111000;      // RW=0,E=0,RS=0    
    _delay_ms(1);                   // delay>40ns tAS
    PORTB= PORTB | 0b00000100;      // E=1, Rest wie bis anhin  
    _delay_ms(1);                   // delay>460ns tpw
    PORTA = Befehl;                 // Daten für Befehl
    _delay_ms(1);                   // delay>80ns tsp2          
    PORTB= PORTB & 0b11111011;      // E=0, Rest wie bis anhin
    _delay_ms(1);                   // delay>10ns thd1 &(5ns thd2)
    PORTB= PORTB & 0b11111100;      // RW=0,RS=0
    PORTA= 0;                       // Port A löschen (gesendete Daten)
    _delay_ms(1);                   // alle delays ab E=1 >500ns tc
    
    */
}
/**************************************************************
Sende-Zeichen-Funktion für das Display Midas
Es können ASCI basierende Zeichen gesendet werden wie 'A' etc.
**************************************************************/
void DisplaySendeZeichen(unsigned char Zeichen)
{
    RW=0;
    E=0;
    RS=0;
    RS=1;
    wait_ms(1);
    E=1;
    wait_ms(1);
    bit0= (Zeichen>>0)&0x01;                 
    bit1= (Zeichen>>1)&0x01;
    bit2= (Zeichen>>2)&0x01;
    bit3= (Zeichen>>3)&0x01;
    bit4= (Zeichen>>4)&0x01;
    bit5= (Zeichen>>5)&0x01;
    bit6= (Zeichen>>6)&0x01;
    bit7= (Zeichen>>7)&0x01;
    wait_ms(1);
    E=0;
    wait_ms(1);
    RS=0;
    RW=0;
    bit0=0;
    bit1=0;
    bit2=0;
    bit3=0;
    bit4=0;
    bit5=0;
    bit6=0;
    bit7=0;
    wait_ms(1);
    
    
    /*PORTB= PORTB & 0b11111000;      // RW=0,E=0,RS=0
    PORTB= PORTB | 0b00000001;      // RS=1
    _delay_ms(1);                   // delay>40ns tsp1
    PORTB= PORTB | 0b00000100;      // E=1, Rest wie bis anhin
    _delay_ms(1);                   // delay>230ns tpw
    PORTA = Zeichen;                // Daten für Zeichen
    _delay_ms(1);                   // delay>80ns tsp2      
    PORTB= PORTB & 0b11111011;      // E=0, Rest wie bis anhin
    _delay_ms(1);                   // delay>10ns thd1 &(5ns thd2)
    PORTB= PORTB & 0b11111100;      // RW=0,RS=0    
    PORTA= 0;                       // Port A löschen (gesendete Daten)                 
    _delay_ms(1);                   // alle delays ab E=1 >500ns tc*/
    
}

/**************************************************************
Sende-String-Funktion für das Display Midas
Es können ASCI basierende Strings gesendet werden wie "ABC" etc.
Der Sendestring ist auf 20 Zeichen beschränkt, da eine Display-
Lein ebenfalls nur 20 Felder besitzt. 
**************************************************************/
void DisplaySendeString(char *String)
{
    int x;
    for(x = 0; (x < 20) && (*String != 0); x++) // solange ein Zeichen=0 ist
    {
        DisplaySendeZeichen(*String);   // Zeichen durch Pointer
        String++;                       // Pointer auf nächstes Zeichen
    }
}

/**************************************************************
Midas Display Initalisierungs-Fuktion
**************************************************************/
void DisplayInit()
{
    wait_ms(40);
    DisplaySendeBefehl(0b00111100); //
    wait_ms(1);
    DisplaySendeBefehl(0b00111100);
    wait_ms(1);
    DisplaySendeBefehl(0b00001000);  
    wait_ms(1);
    DisplaySendeBefehl(0b00000001);
    wait_ms(3);
    DisplaySendeBefehl(0b00000110);
     
    
         
       
        

    /*_delay_ms(20);                     // delay>15ms
    DisplaySendeBefehl(0b00110000);     // Instruktion
    _delay_ms(5);                       // delay>4.1ms  
    DisplaySendeBefehl(0b00110000);     // Instruktion
    _delay_ms(5);                       // delay>100us 
    DisplaySendeBefehl(0b00110000);     // Instruktion
    DisplaySendeBefehl(0b00111100);     // 8bit-,2line-,5x11dots mode
    DisplaySendeBefehl(0b00001000);     // Display off
    DisplaySendeBefehl(0b00000001);     // Display clear
    DisplaySendeBefehl(0b00000110);     // Entry mode set*/
}

/**************************************************************
 Gehe zu X, Y -Funktion für das Display.
 X ist die Horizontale, Y die Vertikale 
 X muss 20<=x>0 sein / Y muss 4<=y>0 sein
 
 Zeilen des Displays wie folgt:
 y
 1. 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 x
 3. 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 x
 2. 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 x
 4. 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 x
**************************************************************/
void gotoxy(unsigned char x, unsigned char y)
{
    unsigned char data = 0; 
        
    switch (y)      
    {
        case 1:
        data = 0b10000000 | (0x00+x-1); // +0 (0x00)
        break;
        
        case 2: //
        data = 0b10000000 | (0x14+x-1); // +20 (0x14)
        break;
        
        case 3:
        data = 0b10000000 | (0x40+x-1); // +64 (0x40)
        break;
        
        case 4:
        data = 0b10000000 | (0x54+x-1); // +84 (0x54)
        break;
        
    }
    DisplaySendeBefehl(data); // Berechneter Übergabeparameter data
}



