#include "SETUP.h"

extern volatile bool buttonSTART_pressed; // Used in the main loop
extern volatile bool buttonSTART_enabled;  // Used for debouncing
extern Timeout buttonSTART_timeout;               // Used for debouncing

// Enables button when bouncing is over
void buttonSTART_enabled_cb(void)
{
    buttonSTART_enabled = true;
}
void buttonSTART_diable_cb(void)
{
    buttonSTART_enabled = false;
}

// ISR handling button pressed event
void buttonSTART_onpressed_cb(void)
{
    if (buttonSTART_enabled) { // Disabled while the button is bouncing
        buttonSTART_enabled = false;
        buttonSTART_pressed = true; // To be read by the main loop
            
        buttonSTART_timeout.attach(callback(buttonSTART_enabled_cb), 0.03); // Debounce time 300 ms
    }
}




