#include "SETUP.h"


int StatusDUO=DUO_DEFAULT;


extern DigitalIn InputKontrollmodul;
extern DigitalIn CutSignal;
int val_CutSignal = 0;


bool Fila_Good = false;

bool ABS = false;

bool PLA = true;

bool ButtonSTART = false;
bool ButtonABBRUCH = false;

extern PwmOut Servo;

extern L6470 **motors;
extern L6470B **motors2;

extern DigitalIn LS_1;
extern DigitalIn LS_2;
extern DigitalIn LS_3;

extern PwmOut Cutter_1;
extern PwmOut Cutter_2;
extern PwmOut Spleisser_1;
extern PwmOut Spleisser_2;


bool get_InputKontrollmodul()
{     
    val_CutSignal = CutSignal.read();
     if( val_CutSignal == 1)
     {
         wait(0.01);
         if(val_CutSignal == 1)
         {
             return true;
         }   
     }
     else if(val_CutSignal == 0)
     {
         wait(0.01);
         if(val_CutSignal == 0)
         {
             return false;
         } 
     }
     else return false;
}



void EntryDuoDefault()
{
      StatusDUO=DUO_DEFAULT;  
}

void EntryDuoStart()
{   
    Stepper_1_Leerlauf();
    Stepper_2_Leerlauf();
    Stepper_3_Leerlauf();
    Set_Servo_Bad_Fil();
    
    DisplaySendeBefehl(0x0C);
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Modus: DUO-Betrieb");
    gotoxy(1,4);
    DisplaySendeString("Start            PLA");
    
    PLA = true;
    ABS = false;

    StatusDUO=DUO_START;
     
}

void EntryDuoEinlegen()
{   
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament einlgenen");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch");
    
    Stepper_1_Run('V', 300);
    
    StatusDUO=DUO_EINLEGEN;
}

void DuoWechselFilament()
{   
    int static x = 0;
    
    if((PLA == true)&& (x == 0))
    {
        gotoxy(1,4);
        DisplaySendeString("Start            ABS");
        
        PLA = false;
        ABS = true;
        x = 1;
    }
    
    if( (ABS == true)&& (x == 0))
    {
        gotoxy(1,4);
        DisplaySendeString("Start            PLA");
        
        PLA = true;
        ABS = false;
    }
    
    if(x == 1)
    {
        x = 0;
    } 
    wait(0.3);
    StatusDUO=DUO_START;
}

void EntryDuoFilaCut1()
{
    /*********************************
    
            CUT PROZESS 
    
    **********************************/
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    Stepper_1_Stop();
    Stepper_3_Leerlauf();

    Stepper_3_SetPara(100, 100);
    Stepper_1_SetPara(100, 100);
 
    Set_Cutter(500, 0, 1);
    motors2[0]->move(StepperMotor::FWD, 128*400*5);
    motors[0]->move(StepperMotor::BWD, 128*400*0.3);
    Set_Cutter(600, 0, 1);
    
    motors2[0]->wait_while_active();
    motors[0]->move(StepperMotor::FWD, 128*400*0.3);
    motors[0]->wait_while_active();
    
    wait(10);
    Set_Servo_Good_Fil();
    Stepper_1_SetHome();
    Stepper_1_Run('V', 150);
   
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament ist gut    ");
    gotoxy(1,3);
    DisplaySendeString("wird gefoerdert...  ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch"); 
    
    StatusDUO=DUO_FILA_CUT1;
}

void EntryDuoFilaBad1()
{
    Stepper_1_SetPara(TRAVELSPEED+100, TRAVELACC+300);
    Stepper_1_GoHome();
   // Set_Servo_Bad_Fil();
   //Stepper_1_Run('V', 150);
   
   StatusDUO=DUO_FILA_BAD1;
}


void EntryDUO()
{
    ButtonSTART = get_Button_1();
    ButtonABBRUCH = get_Button_2();
    Fila_Good = get_InputKontrollmodul();
    
    switch(StatusDUO)
    {     
       case DUO_DEFAULT:
      
       EntryDuoStart();      
       break;
       
       case DUO_START:
        printf("MODUS DUO\n\r");
       if(ButtonSTART==true)
        {
            ButtonSTART=false;   
            EntryDuoEinlegen();     
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            DuoWechselFilament();
        }
        
       break;
       
       case DUO_EINLEGEN:
       if(Fila_Good == false)        //für Test->==false wenn gedrückt(heisst Filament ist gut)
        {
            EntryDuoFilaCut1();     
        }
        
       else if(ButtonABBRUCH == true)
        {    
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
        
       break;
       
       case DUO_FILA_CUT1:
       if(Fila_Good == true)        //für Test->==true wenn gedrückt(heisst Filament ist schlecht) 
        {
            EntryDuoFilaBad1();
        }
       else if(LS_3 == 0)
        {
            EntryDuoDefault();// nur für test
            //EntryFilaGood2();  
        }
       else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();        
        }
       break;
       
       case DUO_FILA_BAD1:
       if(Fila_Good == false)       //für Test->==false wenn gedrückt(heisst Filament ist gut)
        {
               
        }
       else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
     
       break;
       
       case DUO_FILA_GOOD2:
       break;
       
       case DUO_FILA_GOOD3:
       break;
       
       case DUO_FILA_CUT2:
       break;
       
       case DUO_FILA_AUSSCHUSS:
       break;
       
       case DUO_FILA_CUT3_1:
       break;
       
       case DUO_FILA_CUT3_2:
       break;
       
       case DUO_SPLEISSEN_VORBE_BAD:
       break;
       
       case DUO_SPLEISSEN_BAD:
       break;
       
       case DUO_SPLEISSEN_VORBE_GOOD:
       break;
       
       case DUO_SPLEISSEN_GOOD:
       break;
       
       case DUO_FILA_BAD2:
       break;
       
       case DUO_FERTIG_BAD:
       break;
             
    }   
}
